"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    domain_id: str,
    user_profile_name: str,
    session_expiration_duration_in_seconds: int = None,
    expires_in_seconds: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated with the Domain's Amazon Elastic File System (EFS) volume. This operation can only be called when the authentication mode equals IAM.  The IAM role or user used to call this API defines the permissions to access the app. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the app. You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or Amazon VPC Endpoints that you specify. For more information, see Connect to SageMaker Studio Through an Interface VPC Endpoint .  The URL that you get from a call to CreatePresignedDomainUrl has a default timeout of 5 minutes. You can configure this value using ExpiresInSeconds. If you try to use the URL after the timeout limit expires, you are directed to the Amazon Web Services console sign-in page.

    Args:
        domain_id(str): The domain ID.
        user_profile_name(str): The name of the UserProfile to sign-in as.
        session_expiration_duration_in_seconds(int, optional): The session expiration duration in seconds. This value defaults to 43200. Defaults to None.
        expires_in_seconds(int, optional): The number of seconds until the pre-signed URL expires. This value defaults to 300. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.presigned.domain_url.create(
                ctx, domain_id=value, user_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.presigned.domain_url.create domain_id=value, user_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_presigned_domain_url",
        op_kwargs={
            "DomainId": domain_id,
            "UserProfileName": user_profile_name,
            "SessionExpirationDurationInSeconds": session_expiration_duration_in_seconds,
            "ExpiresInSeconds": expires_in_seconds,
        },
    )
