"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    pipeline_execution_arn: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of parameters for a pipeline execution.

    Args:
        pipeline_execution_arn(str): The Amazon Resource Name (ARN) of the pipeline execution.
        next_token(str, optional): If the result of the previous ListPipelineParametersForExecution request was truncated, the response includes a NextToken. To retrieve the next set of parameters, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of parameters to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.parameter_for_execution.list(
                ctx, pipeline_execution_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.parameter_for_execution.list pipeline_execution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_pipeline_parameters_for_execution",
        op_kwargs={
            "PipelineExecutionArn": pipeline_execution_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
