"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    pipeline_name: str,
    pipeline_definition: str,
    client_request_token: str,
    role_arn: str,
    pipeline_display_name: str = None,
    pipeline_description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a pipeline using a JSON pipeline definition.

    Args:
        pipeline_name(str): The name of the pipeline.
        pipeline_display_name(str, optional): The display name of the pipeline. Defaults to None.
        pipeline_definition(str): The JSON pipeline definition of the pipeline.
        pipeline_description(str, optional): A description of the pipeline. Defaults to None.
        client_request_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.
        role_arn(str): The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.
        tags(List, optional): A list of tags to apply to the created pipeline. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.init.create(
                ctx,
                pipeline_name=value,
                pipeline_definition=value,
                client_request_token=value,
                role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.init.create pipeline_name=value, pipeline_definition=value, client_request_token=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_pipeline",
        op_kwargs={
            "PipelineName": pipeline_name,
            "PipelineDisplayName": pipeline_display_name,
            "PipelineDefinition": pipeline_definition,
            "PipelineDescription": pipeline_description,
            "ClientRequestToken": client_request_token,
            "RoleArn": role_arn,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, pipeline_name: str, client_request_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all running instances of the pipeline using the StopPipelineExecution API. When you delete a pipeline, all instances of the pipeline are deleted.

    Args:
        pipeline_name(str): The name of the pipeline to delete.
        client_request_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.init.delete(
                ctx, pipeline_name=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.init.delete pipeline_name=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_pipeline",
        op_kwargs={
            "PipelineName": pipeline_name,
            "ClientRequestToken": client_request_token,
        },
    )


async def describe(hub, ctx, pipeline_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the details of a pipeline.

    Args:
        pipeline_name(str): The name of the pipeline to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.init.describe(ctx, pipeline_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.init.describe pipeline_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_pipeline",
        op_kwargs={"PipelineName": pipeline_name},
    )


async def list_all(
    hub,
    ctx,
    pipeline_name_prefix: str = None,
    created_after: str = None,
    created_before: str = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of pipelines.

    Args:
        pipeline_name_prefix(str, optional): The prefix of the pipeline name. Defaults to None.
        created_after(str, optional): A filter that returns the pipelines that were created after a specified time. Defaults to None.
        created_before(str, optional): A filter that returns the pipelines that were created before a specified time. Defaults to None.
        sort_by(str, optional): The field by which to sort results. The default is CreatedTime. Defaults to None.
        sort_order(str, optional): The sort order for results. Defaults to None.
        next_token(str, optional): If the result of the previous ListPipelines request was truncated, the response includes a NextToken. To retrieve the next set of pipelines, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of pipelines to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_pipelines",
        op_kwargs={
            "PipelineNamePrefix": pipeline_name_prefix,
            "CreatedAfter": created_after,
            "CreatedBefore": created_before,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    pipeline_name: str,
    pipeline_display_name: str = None,
    pipeline_definition: str = None,
    pipeline_description: str = None,
    role_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a pipeline.

    Args:
        pipeline_name(str): The name of the pipeline to update.
        pipeline_display_name(str, optional): The display name of the pipeline. Defaults to None.
        pipeline_definition(str, optional): The JSON pipeline definition. Defaults to None.
        pipeline_description(str, optional): The description of the pipeline. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) that the pipeline uses to execute. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.init.update(ctx, pipeline_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.init.update pipeline_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_pipeline",
        op_kwargs={
            "PipelineName": pipeline_name,
            "PipelineDisplayName": pipeline_display_name,
            "PipelineDefinition": pipeline_definition,
            "PipelineDescription": pipeline_description,
            "RoleArn": role_arn,
        },
    )
