"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def send(
    hub,
    ctx,
    callback_token: str,
    output_parameters: List = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Notifies the pipeline that the execution of a callback step succeeded and provides a list of the step's output parameters. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).

    Args:
        callback_token(str): The pipeline generated token from the Amazon SQS queue.
        output_parameters(List, optional): A list of the output parameters of the callback step. Defaults to None.
        client_request_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.execution.step.success.send(
                ctx, callback_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.execution.step.success.send callback_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="send_pipeline_execution_step_success",
        op_kwargs={
            "CallbackToken": callback_token,
            "OutputParameters": output_parameters,
            "ClientRequestToken": client_request_token,
        },
    )
