"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    pipeline_execution_arn: str = None,
    next_token: str = None,
    max_results: int = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of PipeLineExecutionStep objects.

    Args:
        pipeline_execution_arn(str, optional): The Amazon Resource Name (ARN) of the pipeline execution. Defaults to None.
        next_token(str, optional): If the result of the previous ListPipelineExecutionSteps request was truncated, the response includes a NextToken. To retrieve the next set of pipeline execution steps, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of pipeline execution steps to return in the response. Defaults to None.
        sort_order(str, optional): The field by which to sort results. The default is CreatedTime. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.execution.step.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.execution.step.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_pipeline_execution_steps",
        op_kwargs={
            "PipelineExecutionArn": pipeline_execution_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
            "SortOrder": sort_order,
        },
    )
