"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub,
    ctx,
    callback_token: str,
    failure_reason: str = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Notifies the pipeline that the execution of a callback step failed, along with a message describing why. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).

    Args:
        callback_token(str): The pipeline generated token from the Amazon SQS queue.
        failure_reason(str, optional): A message describing why the step failed. Defaults to None.
        client_request_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.execution.step.failure.send(
                ctx, callback_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.execution.step.failure.send callback_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="send_pipeline_execution_step_failure",
        op_kwargs={
            "CallbackToken": callback_token,
            "FailureReason": failure_reason,
            "ClientRequestToken": client_request_token,
        },
    )
