"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, pipeline_execution_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the details of a pipeline execution.

    Args:
        pipeline_execution_arn(str): The Amazon Resource Name (ARN) of the pipeline execution.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.execution.init.describe(
                ctx, pipeline_execution_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.execution.init.describe pipeline_execution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_pipeline_execution",
        op_kwargs={"PipelineExecutionArn": pipeline_execution_arn},
    )


async def list_all(
    hub,
    ctx,
    pipeline_name: str,
    created_after: str = None,
    created_before: str = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the pipeline executions.

    Args:
        pipeline_name(str): The name of the pipeline.
        created_after(str, optional): A filter that returns the pipeline executions that were created after a specified time. Defaults to None.
        created_before(str, optional): A filter that returns the pipeline executions that were created before a specified time. Defaults to None.
        sort_by(str, optional): The field by which to sort results. The default is CreatedTime. Defaults to None.
        sort_order(str, optional): The sort order for results. Defaults to None.
        next_token(str, optional): If the result of the previous ListPipelineExecutions request was truncated, the response includes a NextToken. To retrieve the next set of pipeline executions, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of pipeline executions to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.execution.init.list_all(
                ctx, pipeline_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.execution.init.list_all pipeline_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_pipeline_executions",
        op_kwargs={
            "PipelineName": pipeline_name,
            "CreatedAfter": created_after,
            "CreatedBefore": created_before,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(
    hub,
    ctx,
    pipeline_name: str,
    client_request_token: str,
    pipeline_execution_display_name: str = None,
    pipeline_parameters: List = None,
    pipeline_execution_description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a pipeline execution.

    Args:
        pipeline_name(str): The name of the pipeline.
        pipeline_execution_display_name(str, optional): The display name of the pipeline execution. Defaults to None.
        pipeline_parameters(List, optional): Contains a list of pipeline parameters. This list can be empty. . Defaults to None.
        pipeline_execution_description(str, optional): The description of the pipeline execution. Defaults to None.
        client_request_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.execution.init.start(
                ctx, pipeline_name=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.execution.init.start pipeline_name=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="start_pipeline_execution",
        op_kwargs={
            "PipelineName": pipeline_name,
            "PipelineExecutionDisplayName": pipeline_execution_display_name,
            "PipelineParameters": pipeline_parameters,
            "PipelineExecutionDescription": pipeline_execution_description,
            "ClientRequestToken": client_request_token,
        },
    )


async def stop(
    hub, ctx, pipeline_execution_arn: str, client_request_token: str
) -> Dict:
    r"""
    **Autogenerated function**

    Stops a pipeline execution. A pipeline execution won't stop while a callback step is running. When you call StopPipelineExecution on a pipeline execution with a running callback step, SageMaker Pipelines sends an additional Amazon SQS message to the specified SQS queue. The body of the SQS message contains a "Status" field which is set to "Stopping". You should add logic to your Amazon SQS message consumer to take any needed action (for example, resource cleanup) upon receipt of the message followed by a call to SendPipelineExecutionStepSuccess or SendPipelineExecutionStepFailure. Only when SageMaker Pipelines receives one of these calls will it stop the pipeline execution.

    Args:
        pipeline_execution_arn(str): The Amazon Resource Name (ARN) of the pipeline execution.
        client_request_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.execution.init.stop(
                ctx, pipeline_execution_arn=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.execution.init.stop pipeline_execution_arn=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="stop_pipeline_execution",
        op_kwargs={
            "PipelineExecutionArn": pipeline_execution_arn,
            "ClientRequestToken": client_request_token,
        },
    )


async def update(
    hub,
    ctx,
    pipeline_execution_arn: str,
    pipeline_execution_description: str = None,
    pipeline_execution_display_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a pipeline execution.

    Args:
        pipeline_execution_arn(str): The Amazon Resource Name (ARN) of the pipeline execution.
        pipeline_execution_description(str, optional): The description of the pipeline execution. Defaults to None.
        pipeline_execution_display_name(str, optional): The display name of the pipeline execution. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.execution.init.update(
                ctx, pipeline_execution_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.execution.init.update pipeline_execution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_pipeline_execution",
        op_kwargs={
            "PipelineExecutionArn": pipeline_execution_arn,
            "PipelineExecutionDescription": pipeline_execution_description,
            "PipelineExecutionDisplayName": pipeline_execution_display_name,
        },
    )
