"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, pipeline_execution_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the details of an execution's pipeline definition.

    Args:
        pipeline_execution_arn(str): The Amazon Resource Name (ARN) of the pipeline execution.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.pipeline.definition_for_execution.describe(
                ctx, pipeline_execution_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.pipeline.definition_for_execution.describe pipeline_execution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_pipeline_definition_for_execution",
        op_kwargs={"PipelineExecutionArn": pipeline_execution_arn},
    )
