"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    notebook_instance_name: str,
    instance_type: str,
    role_arn: str,
    subnet_id: str = None,
    security_group_ids: List = None,
    kms_key_id: str = None,
    tags: List = None,
    lifecycle_config_name: str = None,
    direct_internet_access: str = None,
    volume_size_in_gb: int = None,
    accelerator_types: List = None,
    default_code_repository: str = None,
    additional_code_repositories: List = None,
    root_access: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook.  In a CreateNotebookInstance request, specify the type of ML compute instance that you want to run. Amazon SageMaker launches the instance, installs common libraries that you can use to explore datasets for model training, and attaches an ML storage volume to the notebook instance.  Amazon SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use Amazon SageMaker with a specific algorithm or with a machine learning framework.  After receiving the request, Amazon SageMaker does the following:   Creates a network interface in the Amazon SageMaker VPC.   (Option) If you specified SubnetId, Amazon SageMaker creates a network interface in your own VPC, which is inferred from the subnet ID that you provide in the input. When creating this network interface, Amazon SageMaker attaches the security group that you specified in the request to the network interface that it creates in your VPC.   Launches an EC2 instance of the type specified in the request in the Amazon SageMaker VPC. If you specified SubnetId of your VPC, Amazon SageMaker specifies both network interfaces when launching this instance. This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow it.   After creating the notebook instance, Amazon SageMaker returns its Amazon Resource Name (ARN). You can't change the name of a notebook instance after you create it. After Amazon SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter notebooks. For example, you can write code to explore a dataset that you can use for model training, train a model, host models by creating Amazon SageMaker endpoints, and validate hosted models.  For more information, see How It Works.

    Args:
        notebook_instance_name(str): The name of the new notebook instance.
        instance_type(str): The type of ML compute instance to launch for the notebook instance.
        subnet_id(str, optional): The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance. . Defaults to None.
        security_group_ids(List, optional): The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as specified in the subnet. . Defaults to None.
        role_arn(str):  When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker assumes this role to perform tasks on your behalf. You must grant this role necessary permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service principal (sagemaker.amazonaws.com) permissions to assume this role. For more information, see Amazon SageMaker Roles.   To be able to pass this role to Amazon SageMaker, the caller of this API must have the iam:PassRole permission. .
        kms_key_id(str, optional): The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information, see Enabling and Disabling Keys in the Amazon Web Services Key Management Service Developer Guide. Defaults to None.
        tags(List, optional): An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see Tagging Amazon Web Services Resources. Defaults to None.
        lifecycle_config_name(str, optional): The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see Step 2.1: (Optional) Customize a Notebook Instance. Defaults to None.
        direct_internet_access(str, optional): Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to Disabled this notebook instance is able to access resources only in your VPC, and is not be able to connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC. For more information, see Notebook Instances Are Internet-Enabled by Default. You can set the value of this parameter to Disabled only if you set a value for the SubnetId parameter. Defaults to None.
        volume_size_in_gb(int, optional): The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB. Defaults to None.
        accelerator_types(List, optional): A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one instance type can be associated with a notebook instance. For more information, see Using Elastic Inference in Amazon SageMaker. Defaults to None.
        default_code_repository(str, optional): A Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in Amazon Web Services CodeCommit or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see Associating Git Repositories with Amazon SageMaker Notebook Instances. Defaults to None.
        additional_code_repositories(List, optional): An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in Amazon Web Services CodeCommit or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see Associating Git Repositories with Amazon SageMaker Notebook Instances. Defaults to None.
        root_access(str, optional): Whether root access is enabled or disabled for users of the notebook instance. The default value is Enabled.  Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.notebook_instance.init.create(
                ctx, notebook_instance_name=value, instance_type=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.notebook_instance.init.create notebook_instance_name=value, instance_type=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_notebook_instance",
        op_kwargs={
            "NotebookInstanceName": notebook_instance_name,
            "InstanceType": instance_type,
            "SubnetId": subnet_id,
            "SecurityGroupIds": security_group_ids,
            "RoleArn": role_arn,
            "KmsKeyId": kms_key_id,
            "Tags": tags,
            "LifecycleConfigName": lifecycle_config_name,
            "DirectInternetAccess": direct_internet_access,
            "VolumeSizeInGB": volume_size_in_gb,
            "AcceleratorTypes": accelerator_types,
            "DefaultCodeRepository": default_code_repository,
            "AdditionalCodeRepositories": additional_code_repositories,
            "RootAccess": root_access,
        },
    )


async def delete(hub, ctx, notebook_instance_name: str) -> None:
    r"""
    **Autogenerated function**

     Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook instance, you must call the StopNotebookInstance API.   When you delete a notebook instance, you lose all of your data. Amazon SageMaker removes the ML compute instance, and deletes the ML storage volume and the network interface associated with the notebook instance.

    Args:
        notebook_instance_name(str): The name of the Amazon SageMaker notebook instance to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.notebook_instance.init.delete(
                ctx, notebook_instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.notebook_instance.init.delete notebook_instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_notebook_instance",
        op_kwargs={"NotebookInstanceName": notebook_instance_name},
    )


async def describe(hub, ctx, notebook_instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a notebook instance.

    Args:
        notebook_instance_name(str): The name of the notebook instance that you want information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.notebook_instance.init.describe(
                ctx, notebook_instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.notebook_instance.init.describe notebook_instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_notebook_instance",
        op_kwargs={"NotebookInstanceName": notebook_instance_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    sort_by: str = None,
    sort_order: str = None,
    name_contains: str = None,
    creation_time_before: str = None,
    creation_time_after: str = None,
    last_modified_time_before: str = None,
    last_modified_time_after: str = None,
    status_equals: str = None,
    notebook_instance_lifecycle_config_name_contains: str = None,
    default_code_repository_contains: str = None,
    additional_code_repository_equals: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the Amazon SageMaker notebook instances in the requester's account in an Amazon Web Services Region.

    Args:
        next_token(str, optional):  If the previous call to the ListNotebookInstances is truncated, the response includes a NextToken. You can use this token in your subsequent ListNotebookInstances request to fetch the next set of notebook instances.   You might specify a filter or a sort order in your request. When response is truncated, you must use the same values for the filer and sort order in the next request.  . Defaults to None.
        max_results(int, optional): The maximum number of notebook instances to return. Defaults to None.
        sort_by(str, optional): The field to sort results by. The default is Name. Defaults to None.
        sort_order(str, optional): The sort order for results. . Defaults to None.
        name_contains(str, optional): A string in the notebook instances' name. This filter returns only notebook instances whose name contains the specified string. Defaults to None.
        creation_time_before(str, optional): A filter that returns only notebook instances that were created before the specified time (timestamp). . Defaults to None.
        creation_time_after(str, optional): A filter that returns only notebook instances that were created after the specified time (timestamp). Defaults to None.
        last_modified_time_before(str, optional): A filter that returns only notebook instances that were modified before the specified time (timestamp). Defaults to None.
        last_modified_time_after(str, optional): A filter that returns only notebook instances that were modified after the specified time (timestamp). Defaults to None.
        status_equals(str, optional): A filter that returns only notebook instances with the specified status. Defaults to None.
        notebook_instance_lifecycle_config_name_contains(str, optional): A string in the name of a notebook instances lifecycle configuration associated with this notebook instance. This filter returns only notebook instances associated with a lifecycle configuration with a name that contains the specified string. Defaults to None.
        default_code_repository_contains(str, optional): A string in the name or URL of a Git repository associated with this notebook instance. This filter returns only notebook instances associated with a git repository with a name that contains the specified string. Defaults to None.
        additional_code_repository_equals(str, optional): A filter that returns only notebook instances with associated with the specified git repository. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.notebook_instance.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.notebook_instance.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_notebook_instances",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NameContains": name_contains,
            "CreationTimeBefore": creation_time_before,
            "CreationTimeAfter": creation_time_after,
            "LastModifiedTimeBefore": last_modified_time_before,
            "LastModifiedTimeAfter": last_modified_time_after,
            "StatusEquals": status_equals,
            "NotebookInstanceLifecycleConfigNameContains": notebook_instance_lifecycle_config_name_contains,
            "DefaultCodeRepositoryContains": default_code_repository_contains,
            "AdditionalCodeRepositoryEquals": additional_code_repository_equals,
        },
    )


async def start(hub, ctx, notebook_instance_name: str) -> None:
    r"""
    **Autogenerated function**

    Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume. After configuring the notebook instance, Amazon SageMaker sets the notebook instance status to InService. A notebook instance's status must be InService before you can connect to your Jupyter notebook.

    Args:
        notebook_instance_name(str): The name of the notebook instance to start.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.notebook_instance.init.start(
                ctx, notebook_instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.notebook_instance.init.start notebook_instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="start_notebook_instance",
        op_kwargs={"NotebookInstanceName": notebook_instance_name},
    )


async def stop(hub, ctx, notebook_instance_name: str) -> None:
    r"""
    **Autogenerated function**

    Terminates the ML compute instance. Before terminating the instance, Amazon SageMaker disconnects the ML storage volume from it. Amazon SageMaker preserves the ML storage volume. Amazon SageMaker stops charging you for the ML compute instance when you call StopNotebookInstance. To access data on the ML storage volume for a notebook instance that has been terminated, call the StartNotebookInstance API. StartNotebookInstance launches another ML compute instance, configures it, and attaches the preserved ML storage volume so you can continue your work.

    Args:
        notebook_instance_name(str): The name of the notebook instance to terminate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.notebook_instance.init.stop(
                ctx, notebook_instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.notebook_instance.init.stop notebook_instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="stop_notebook_instance",
        op_kwargs={"NotebookInstanceName": notebook_instance_name},
    )


async def update(
    hub,
    ctx,
    notebook_instance_name: str,
    instance_type: str = None,
    role_arn: str = None,
    lifecycle_config_name: str = None,
    disassociate_lifecycle_config: bool = None,
    volume_size_in_gb: int = None,
    default_code_repository: str = None,
    additional_code_repositories: List = None,
    accelerator_types: List = None,
    disassociate_accelerator_types: bool = None,
    disassociate_default_code_repository: bool = None,
    disassociate_additional_code_repositories: bool = None,
    root_access: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance used for your notebook instance to accommodate changes in your workload requirements.

    Args:
        notebook_instance_name(str): The name of the notebook instance to update.
        instance_type(str, optional): The Amazon ML compute instance type. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access the notebook instance. For more information, see Amazon SageMaker Roles.   To be able to pass this role to Amazon SageMaker, the caller of this API must have the iam:PassRole permission. . Defaults to None.
        lifecycle_config_name(str, optional): The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see Step 2.1: (Optional) Customize a Notebook Instance. Defaults to None.
        disassociate_lifecycle_config(bool, optional): Set to true to remove the notebook instance lifecycle configuration currently associated with the notebook instance. This operation is idempotent. If you specify a lifecycle configuration that is not associated with the notebook instance when you call this method, it does not throw an error. Defaults to None.
        volume_size_in_gb(int, optional): The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB. ML storage volumes are encrypted, so Amazon SageMaker can't determine the amount of available free space on the volume. Because of this, you can increase the volume size when you update a notebook instance, but you can't decrease the volume size. If you want to decrease the size of the ML storage volume in use, create a new notebook instance with the desired size. Defaults to None.
        default_code_repository(str, optional): The Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in Amazon Web Services CodeCommit or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see Associating Git Repositories with Amazon SageMaker Notebook Instances. Defaults to None.
        additional_code_repositories(List, optional): An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in Amazon Web Services CodeCommit or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see Associating Git Repositories with Amazon SageMaker Notebook Instances. Defaults to None.
        accelerator_types(List, optional): A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see Using Elastic Inference in Amazon SageMaker. Defaults to None.
        disassociate_accelerator_types(bool, optional): A list of the Elastic Inference (EI) instance types to remove from this notebook instance. This operation is idempotent. If you specify an accelerator type that is not associated with the notebook instance when you call this method, it does not throw an error. Defaults to None.
        disassociate_default_code_repository(bool, optional): The name or URL of the default Git repository to remove from this notebook instance. This operation is idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this method, it does not throw an error. Defaults to None.
        disassociate_additional_code_repositories(bool, optional): A list of names or URLs of the default Git repositories to remove from this notebook instance. This operation is idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this method, it does not throw an error. Defaults to None.
        root_access(str, optional): Whether root access is enabled or disabled for users of the notebook instance. The default value is Enabled.  If you set this to Disabled, users don't have root access on the notebook instance, but lifecycle configuration scripts still run with root permissions. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.notebook_instance.init.update(
                ctx, notebook_instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.notebook_instance.init.update notebook_instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_notebook_instance",
        op_kwargs={
            "NotebookInstanceName": notebook_instance_name,
            "InstanceType": instance_type,
            "RoleArn": role_arn,
            "LifecycleConfigName": lifecycle_config_name,
            "DisassociateLifecycleConfig": disassociate_lifecycle_config,
            "VolumeSizeInGB": volume_size_in_gb,
            "DefaultCodeRepository": default_code_repository,
            "AdditionalCodeRepositories": additional_code_repositories,
            "AcceleratorTypes": accelerator_types,
            "DisassociateAcceleratorTypes": disassociate_accelerator_types,
            "DisassociateDefaultCodeRepository": disassociate_default_code_repository,
            "DisassociateAdditionalCodeRepositories": disassociate_additional_code_repositories,
            "RootAccess": root_access,
        },
    )
