"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    monitoring_schedule_name: str,
    monitoring_schedule_config: Dict,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an Amazon SageMaker Endoint.

    Args:
        monitoring_schedule_name(str): The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an Amazon Web Services account.
        monitoring_schedule_config(Dict): The configuration object that specifies the monitoring schedule and defines the monitoring job.
        tags(List, optional): (Optional) An array of key-value pairs. For more information, see Using Cost Allocation Tags in the Amazon Web Services Billing and Cost Management User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.monitoring.schedule.create(
                ctx, monitoring_schedule_name=value, monitoring_schedule_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.monitoring.schedule.create monitoring_schedule_name=value, monitoring_schedule_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_monitoring_schedule",
        op_kwargs={
            "MonitoringScheduleName": monitoring_schedule_name,
            "MonitoringScheduleConfig": monitoring_schedule_config,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, monitoring_schedule_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job execution history of the monitoring schedule.

    Args:
        monitoring_schedule_name(str): The name of the monitoring schedule to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.monitoring.schedule.delete(
                ctx, monitoring_schedule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.monitoring.schedule.delete monitoring_schedule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_monitoring_schedule",
        op_kwargs={"MonitoringScheduleName": monitoring_schedule_name},
    )


async def describe(hub, ctx, monitoring_schedule_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the schedule for a monitoring job.

    Args:
        monitoring_schedule_name(str): Name of a previously created monitoring schedule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.monitoring.schedule.describe(
                ctx, monitoring_schedule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.monitoring.schedule.describe monitoring_schedule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_monitoring_schedule",
        op_kwargs={"MonitoringScheduleName": monitoring_schedule_name},
    )


async def list_all(
    hub,
    ctx,
    endpoint_name: str = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
    name_contains: str = None,
    creation_time_before: str = None,
    creation_time_after: str = None,
    last_modified_time_before: str = None,
    last_modified_time_after: str = None,
    status_equals: str = None,
    monitoring_job_definition_name: str = None,
    monitoring_type_equals: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns list of all monitoring schedules.

    Args:
        endpoint_name(str, optional): Name of a specific endpoint to fetch schedules for. Defaults to None.
        sort_by(str, optional): Whether to sort results by Status, CreationTime, ScheduledTime field. The default is CreationTime. Defaults to None.
        sort_order(str, optional): Whether to sort the results in Ascending or Descending order. The default is Descending. Defaults to None.
        next_token(str, optional): The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request. Defaults to None.
        max_results(int, optional): The maximum number of jobs to return in the response. The default value is 10. Defaults to None.
        name_contains(str, optional): Filter for monitoring schedules whose name contains a specified string. Defaults to None.
        creation_time_before(str, optional): A filter that returns only monitoring schedules created before a specified time. Defaults to None.
        creation_time_after(str, optional): A filter that returns only monitoring schedules created after a specified time. Defaults to None.
        last_modified_time_before(str, optional): A filter that returns only monitoring schedules modified before a specified time. Defaults to None.
        last_modified_time_after(str, optional): A filter that returns only monitoring schedules modified after a specified time. Defaults to None.
        status_equals(str, optional): A filter that returns only monitoring schedules modified before a specified time. Defaults to None.
        monitoring_job_definition_name(str, optional): Gets a list of the monitoring schedules for the specified monitoring job definition. Defaults to None.
        monitoring_type_equals(str, optional): A filter that returns only the monitoring schedules for the specified monitoring type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.monitoring.schedule.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.monitoring.schedule.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_monitoring_schedules",
        op_kwargs={
            "EndpointName": endpoint_name,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
            "NameContains": name_contains,
            "CreationTimeBefore": creation_time_before,
            "CreationTimeAfter": creation_time_after,
            "LastModifiedTimeBefore": last_modified_time_before,
            "LastModifiedTimeAfter": last_modified_time_after,
            "StatusEquals": status_equals,
            "MonitoringJobDefinitionName": monitoring_job_definition_name,
            "MonitoringTypeEquals": monitoring_type_equals,
        },
    )


async def start(hub, ctx, monitoring_schedule_name: str) -> None:
    r"""
    **Autogenerated function**

    Starts a previously stopped monitoring schedule.  By default, when you successfully create a new schedule, the status of a monitoring schedule is scheduled.

    Args:
        monitoring_schedule_name(str): The name of the schedule to start.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.monitoring.schedule.start(
                ctx, monitoring_schedule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.monitoring.schedule.start monitoring_schedule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="start_monitoring_schedule",
        op_kwargs={"MonitoringScheduleName": monitoring_schedule_name},
    )


async def stop(hub, ctx, monitoring_schedule_name: str) -> None:
    r"""
    **Autogenerated function**

    Stops a previously started monitoring schedule.

    Args:
        monitoring_schedule_name(str): The name of the schedule to stop.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.monitoring.schedule.stop(
                ctx, monitoring_schedule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.monitoring.schedule.stop monitoring_schedule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="stop_monitoring_schedule",
        op_kwargs={"MonitoringScheduleName": monitoring_schedule_name},
    )


async def update(
    hub, ctx, monitoring_schedule_name: str, monitoring_schedule_config: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a previously created schedule.

    Args:
        monitoring_schedule_name(str): The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an Amazon Web Services account.
        monitoring_schedule_config(Dict): The configuration object that specifies the monitoring schedule and defines the monitoring job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.monitoring.schedule.update(
                ctx, monitoring_schedule_name=value, monitoring_schedule_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.monitoring.schedule.update monitoring_schedule_name=value, monitoring_schedule_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_monitoring_schedule",
        op_kwargs={
            "MonitoringScheduleName": monitoring_schedule_name,
            "MonitoringScheduleConfig": monitoring_schedule_config,
        },
    )
