"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    job_definition_name: str,
    model_quality_app_specification: Dict,
    model_quality_job_input: Dict,
    model_quality_job_output_config: Dict,
    job_resources: Dict,
    role_arn: str,
    model_quality_baseline_config: Dict = None,
    network_config: Dict = None,
    stopping_condition: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a definition for a job that monitors model quality and drift. For information about model monitor, see Amazon SageMaker Model Monitor.

    Args:
        job_definition_name(str): The name of the monitoring job definition.
        model_quality_baseline_config(Dict, optional): Specifies the constraints and baselines for the monitoring job. Defaults to None.
        model_quality_app_specification(Dict): The container that runs the monitoring job.
        model_quality_job_input(Dict): A list of the inputs that are monitored. Currently endpoints are supported.
        model_quality_job_output_config(Dict): The output configuration for monitoring jobs.
        job_resources(Dict): Identifies the resources to deploy for a monitoring job.
        network_config(Dict, optional): Specifies the network configuration for the monitoring job. Defaults to None.
        role_arn(str): The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        stopping_condition(Dict, optional): A time limit for how long the monitoring job is allowed to run before stopping. Defaults to None.
        tags(List, optional): (Optional) An array of key-value pairs. For more information, see Using Cost Allocation Tags in the Amazon Web Services Billing and Cost Management User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.quality_job_definition.create(
                ctx,
                job_definition_name=value,
                model_quality_app_specification=value,
                model_quality_job_input=value,
                model_quality_job_output_config=value,
                job_resources=value,
                role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.quality_job_definition.create job_definition_name=value, model_quality_app_specification=value, model_quality_job_input=value, model_quality_job_output_config=value, job_resources=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_model_quality_job_definition",
        op_kwargs={
            "JobDefinitionName": job_definition_name,
            "ModelQualityBaselineConfig": model_quality_baseline_config,
            "ModelQualityAppSpecification": model_quality_app_specification,
            "ModelQualityJobInput": model_quality_job_input,
            "ModelQualityJobOutputConfig": model_quality_job_output_config,
            "JobResources": job_resources,
            "NetworkConfig": network_config,
            "RoleArn": role_arn,
            "StoppingCondition": stopping_condition,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, job_definition_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the secified model quality monitoring job definition.

    Args:
        job_definition_name(str): The name of the model quality monitoring job definition to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.quality_job_definition.delete(
                ctx, job_definition_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.quality_job_definition.delete job_definition_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_model_quality_job_definition",
        op_kwargs={"JobDefinitionName": job_definition_name},
    )


async def describe(hub, ctx, job_definition_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of a model quality job definition.

    Args:
        job_definition_name(str): The name of the model quality job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.quality_job_definition.describe(
                ctx, job_definition_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.quality_job_definition.describe job_definition_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_model_quality_job_definition",
        op_kwargs={"JobDefinitionName": job_definition_name},
    )


async def list_all(
    hub,
    ctx,
    endpoint_name: str = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
    name_contains: str = None,
    creation_time_before: str = None,
    creation_time_after: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of model quality monitoring job definitions in your account.

    Args:
        endpoint_name(str, optional): A filter that returns only model quality monitoring job definitions that are associated with the specified endpoint. Defaults to None.
        sort_by(str, optional): The field to sort results by. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Descending. Defaults to None.
        next_token(str, optional): If the result of the previous ListModelQualityJobDefinitions request was truncated, the response includes a NextToken. To retrieve the next set of model quality monitoring job definitions, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a call to ListModelQualityJobDefinitions. Defaults to None.
        name_contains(str, optional): A string in the transform job name. This filter returns only model quality monitoring job definitions whose name contains the specified string. Defaults to None.
        creation_time_before(str, optional): A filter that returns only model quality monitoring job definitions created before the specified time. Defaults to None.
        creation_time_after(str, optional): A filter that returns only model quality monitoring job definitions created after the specified time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.quality_job_definition.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.quality_job_definition.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_model_quality_job_definitions",
        op_kwargs={
            "EndpointName": endpoint_name,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
            "NameContains": name_contains,
            "CreationTimeBefore": creation_time_before,
            "CreationTimeAfter": creation_time_after,
        },
    )
