"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    model_package_name: str = None,
    model_package_group_name: str = None,
    model_package_description: str = None,
    inference_specification: Dict = None,
    validation_specification: Dict = None,
    source_algorithm_specification: Dict = None,
    certify_for_marketplace: bool = None,
    tags: List = None,
    model_approval_status: str = None,
    metadata_properties: Dict = None,
    model_metrics: Dict = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a model package that you can use to create Amazon SageMaker models or list on Amazon Web Services Marketplace, or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in Amazon SageMaker. To create a model package by specifying a Docker container that contains your inference code and the Amazon S3 location of your model artifacts, provide values for InferenceSpecification. To create a model from an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for SourceAlgorithmSpecification.  There are two types of model packages:   Versioned - a model that is part of a model group in the model registry.   Unversioned - a model package that is not part of a model group.

    Args:
        model_package_name(str, optional): The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen). This parameter is required for unversioned models. It is not applicable to versioned models. Defaults to None.
        model_package_group_name(str, optional): The name of the model group that this model version belongs to. This parameter is required for versioned models, and does not apply to unversioned models. Defaults to None.
        model_package_description(str, optional): A description of the model package. Defaults to None.
        inference_specification(Dict, optional): Specifies details about inference jobs that can be run with models based on this model package, including the following:   The Amazon ECR paths of containers that contain the inference code and model artifacts.   The instance types that the model package supports for transform jobs and real-time endpoints used for inference.   The input and output content formats that the model package supports for inference.  . Defaults to None.
        validation_specification(Dict, optional): Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package. Defaults to None.
        source_algorithm_specification(Dict, optional): Details about the algorithm that was used to create the model package. Defaults to None.
        certify_for_marketplace(bool, optional): Whether to certify the model package for listing on Amazon Web Services Marketplace. This parameter is optional for unversioned models, and does not apply to versioned models. Defaults to None.
        tags(List, optional): A list of key value pairs associated with the model. For more information, see Tagging Amazon Web Services resources in the Amazon Web Services General Reference Guide. Defaults to None.
        model_approval_status(str, optional): Whether the model is approved for deployment. This parameter is optional for versioned models, and does not apply to unversioned models. For versioned models, the value of this parameter must be set to Approved to deploy the model. Defaults to None.
        metadata_properties(Dict, optional): Metadata properties of the tracking entity, trial, or trial component. Defaults to None.
        model_metrics(Dict, optional): A structure that contains model metrics reports. Defaults to None.
        client_token(str, optional): A unique token that guarantees that the call to this API is idempotent. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_model_package",
        op_kwargs={
            "ModelPackageName": model_package_name,
            "ModelPackageGroupName": model_package_group_name,
            "ModelPackageDescription": model_package_description,
            "InferenceSpecification": inference_specification,
            "ValidationSpecification": validation_specification,
            "SourceAlgorithmSpecification": source_algorithm_specification,
            "CertifyForMarketplace": certify_for_marketplace,
            "Tags": tags,
            "ModelApprovalStatus": model_approval_status,
            "MetadataProperties": metadata_properties,
            "ModelMetrics": model_metrics,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, model_package_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a model package. A model package is used to create Amazon SageMaker models or list on Amazon Web Services Marketplace. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in Amazon SageMaker.

    Args:
        model_package_name(str): The name or Amazon Resource Name (ARN) of the model package to delete. When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.init.delete(
                ctx, model_package_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.init.delete model_package_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_model_package",
        op_kwargs={"ModelPackageName": model_package_name},
    )


async def describe(hub, ctx, model_package_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of the specified model package, which is used to create Amazon SageMaker models or list them on Amazon Web Services Marketplace. To create models in Amazon SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.

    Args:
        model_package_name(str): The name or Amazon Resource Name (ARN) of the model package to describe. When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.init.describe(
                ctx, model_package_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.init.describe model_package_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_model_package",
        op_kwargs={"ModelPackageName": model_package_name},
    )


async def list_all(
    hub,
    ctx,
    creation_time_after: str = None,
    creation_time_before: str = None,
    max_results: int = None,
    name_contains: str = None,
    model_approval_status: str = None,
    model_package_group_name: str = None,
    model_package_type: str = None,
    next_token: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the model packages that have been created.

    Args:
        creation_time_after(str, optional): A filter that returns only model packages created after the specified time (timestamp). Defaults to None.
        creation_time_before(str, optional): A filter that returns only model packages created before the specified time (timestamp). Defaults to None.
        max_results(int, optional): The maximum number of model packages to return in the response. Defaults to None.
        name_contains(str, optional): A string in the model package name. This filter returns only model packages whose name contains the specified string. Defaults to None.
        model_approval_status(str, optional): A filter that returns only the model packages with the specified approval status. Defaults to None.
        model_package_group_name(str, optional): A filter that returns only model versions that belong to the specified model group. Defaults to None.
        model_package_type(str, optional): A filter that returns onlyl the model packages of the specified type. This can be one of the following values.    VERSIONED - List only versioned models.    UNVERSIONED - List only unversioined models.    BOTH - List both versioned and unversioned models.  . Defaults to None.
        next_token(str, optional): If the response to a previous ListModelPackages request was truncated, the response includes a NextToken. To retrieve the next set of model packages, use the token in the next request. Defaults to None.
        sort_by(str, optional): The parameter by which to sort the results. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for the results. The default is Ascending. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_model_packages",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "MaxResults": max_results,
            "NameContains": name_contains,
            "ModelApprovalStatus": model_approval_status,
            "ModelPackageGroupName": model_package_group_name,
            "ModelPackageType": model_package_type,
            "NextToken": next_token,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )


async def update(
    hub,
    ctx,
    model_package_arn: str,
    model_approval_status: str,
    approval_description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a versioned model.

    Args:
        model_package_arn(str): The Amazon Resource Name (ARN) of the model.
        model_approval_status(str): The approval status of the model.
        approval_description(str, optional): A description for the approval status of the model. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.init.update(
                ctx, model_package_arn=value, model_approval_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.init.update model_package_arn=value, model_approval_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_model_package",
        op_kwargs={
            "ModelPackageArn": model_package_arn,
            "ModelApprovalStatus": model_approval_status,
            "ApprovalDescription": approval_description,
        },
    )
