"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, model_package_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a model group resource policy.

    Args:
        model_package_group_name(str): The name of the model group for which to delete the policy.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.group.policy.delete(
                ctx, model_package_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.group.policy.delete model_package_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_model_package_group_policy",
        op_kwargs={"ModelPackageGroupName": model_package_group_name},
    )


async def get(hub, ctx, model_package_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a resource policy that manages access for a model group. For information about resource policies, see Identity-based policies and resource-based policies in the Amazon Web Services Identity and Access Management User Guide..

    Args:
        model_package_group_name(str): The name of the model group for which to get the resource policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.group.policy.get(
                ctx, model_package_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.group.policy.get model_package_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="get_model_package_group_policy",
        op_kwargs={"ModelPackageGroupName": model_package_group_name},
    )


async def put(hub, ctx, model_package_group_name: str, resource_policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds a resouce policy to control access to a model group. For information about resoure policies, see Identity-based policies and resource-based policies in the Amazon Web Services Identity and Access Management User Guide..

    Args:
        model_package_group_name(str): The name of the model group to add a resource policy to.
        resource_policy(str): The resource policy for the model group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.group.policy.put(
                ctx, model_package_group_name=value, resource_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.group.policy.put model_package_group_name=value, resource_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="put_model_package_group_policy",
        op_kwargs={
            "ModelPackageGroupName": model_package_group_name,
            "ResourcePolicy": resource_policy,
        },
    )
