"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    model_package_group_name: str,
    model_package_group_description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a model group. A model group contains a group of model versions.

    Args:
        model_package_group_name(str): The name of the model group.
        model_package_group_description(str, optional): A description for the model group. Defaults to None.
        tags(List, optional): A list of key value pairs associated with the model group. For more information, see Tagging Amazon Web Services resources in the Amazon Web Services General Reference Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.group.init.create(
                ctx, model_package_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.group.init.create model_package_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_model_package_group",
        op_kwargs={
            "ModelPackageGroupName": model_package_group_name,
            "ModelPackageGroupDescription": model_package_group_description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, model_package_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified model group.

    Args:
        model_package_group_name(str): The name of the model group to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.group.init.delete(
                ctx, model_package_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.group.init.delete model_package_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_model_package_group",
        op_kwargs={"ModelPackageGroupName": model_package_group_name},
    )


async def describe(hub, ctx, model_package_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a description for the specified model group.

    Args:
        model_package_group_name(str): The name of the model group to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.group.init.describe(
                ctx, model_package_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.group.init.describe model_package_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_model_package_group",
        op_kwargs={"ModelPackageGroupName": model_package_group_name},
    )


async def list_all(
    hub,
    ctx,
    creation_time_after: str = None,
    creation_time_before: str = None,
    max_results: int = None,
    name_contains: str = None,
    next_token: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of the model groups in your Amazon Web Services account.

    Args:
        creation_time_after(str, optional): A filter that returns only model groups created after the specified time. Defaults to None.
        creation_time_before(str, optional): A filter that returns only model groups created before the specified time. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        name_contains(str, optional): A string in the model group name. This filter returns only model groups whose name contains the specified string. Defaults to None.
        next_token(str, optional): If the result of the previous ListModelPackageGroups request was truncated, the response includes a NextToken. To retrieve the next set of model groups, use the token in the next request. Defaults to None.
        sort_by(str, optional): The field to sort results by. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Ascending. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.package.group.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.package.group.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_model_package_groups",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "MaxResults": max_results,
            "NameContains": name_contains,
            "NextToken": next_token,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )
