"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    job_definition_name: str,
    model_explainability_app_specification: Dict,
    model_explainability_job_input: Dict,
    model_explainability_job_output_config: Dict,
    job_resources: Dict,
    role_arn: str,
    model_explainability_baseline_config: Dict = None,
    network_config: Dict = None,
    stopping_condition: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates the definition for a model explainability job.

    Args:
        job_definition_name(str):  The name of the model explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.
        model_explainability_baseline_config(Dict, optional): The baseline configuration for a model explainability job. Defaults to None.
        model_explainability_app_specification(Dict): Configures the model explainability job to run a specified Docker container image.
        model_explainability_job_input(Dict): Inputs for the model explainability job.
        model_explainability_job_output_config(Dict): The output configuration for monitoring jobs.
        job_resources(Dict): Identifies the resources to deploy for a monitoring job.
        network_config(Dict, optional): Networking options for a model explainability job. Defaults to None.
        role_arn(str): The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        stopping_condition(Dict, optional): A time limit for how long the monitoring job is allowed to run before stopping. Defaults to None.
        tags(List, optional): (Optional) An array of key-value pairs. For more information, see Using Cost Allocation Tags in the Amazon Web Services Billing and Cost Management User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.explainability_job_definition.create(
                ctx,
                job_definition_name=value,
                model_explainability_app_specification=value,
                model_explainability_job_input=value,
                model_explainability_job_output_config=value,
                job_resources=value,
                role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.explainability_job_definition.create job_definition_name=value, model_explainability_app_specification=value, model_explainability_job_input=value, model_explainability_job_output_config=value, job_resources=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_model_explainability_job_definition",
        op_kwargs={
            "JobDefinitionName": job_definition_name,
            "ModelExplainabilityBaselineConfig": model_explainability_baseline_config,
            "ModelExplainabilityAppSpecification": model_explainability_app_specification,
            "ModelExplainabilityJobInput": model_explainability_job_input,
            "ModelExplainabilityJobOutputConfig": model_explainability_job_output_config,
            "JobResources": job_resources,
            "NetworkConfig": network_config,
            "RoleArn": role_arn,
            "StoppingCondition": stopping_condition,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, job_definition_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an Amazon SageMaker model explainability job definition.

    Args:
        job_definition_name(str): The name of the model explainability job definition to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.explainability_job_definition.delete(
                ctx, job_definition_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.explainability_job_definition.delete job_definition_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_model_explainability_job_definition",
        op_kwargs={"JobDefinitionName": job_definition_name},
    )


async def describe(hub, ctx, job_definition_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of a model explainability job definition.

    Args:
        job_definition_name(str): The name of the model explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.explainability_job_definition.describe(
                ctx, job_definition_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.explainability_job_definition.describe job_definition_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_model_explainability_job_definition",
        op_kwargs={"JobDefinitionName": job_definition_name},
    )


async def list_all(
    hub,
    ctx,
    endpoint_name: str = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
    name_contains: str = None,
    creation_time_before: str = None,
    creation_time_after: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists model explainability job definitions that satisfy various filters.

    Args:
        endpoint_name(str, optional): Name of the endpoint to monitor for model explainability. Defaults to None.
        sort_by(str, optional): Whether to sort results by the Name or CreationTime field. The default is CreationTime. Defaults to None.
        sort_order(str, optional): Whether to sort the results in Ascending or Descending order. The default is Descending. Defaults to None.
        next_token(str, optional): The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request. Defaults to None.
        max_results(int, optional): The maximum number of jobs to return in the response. The default value is 10. Defaults to None.
        name_contains(str, optional): Filter for model explainability jobs whose name contains a specified string. Defaults to None.
        creation_time_before(str, optional): A filter that returns only model explainability jobs created before a specified time. Defaults to None.
        creation_time_after(str, optional): A filter that returns only model explainability jobs created after a specified time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.model.explainability_job_definition.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.model.explainability_job_definition.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_model_explainability_job_definitions",
        op_kwargs={
            "EndpointName": endpoint_name,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
            "NameContains": name_contains,
            "CreationTimeBefore": creation_time_before,
            "CreationTimeAfter": creation_time_after,
        },
    )
