"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    workteam_arn: str,
    max_results: int = None,
    next_token: str = None,
    creation_time_after: str = None,
    creation_time_before: str = None,
    job_reference_code_contains: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of labeling jobs assigned to a specified work team.

    Args:
        workteam_arn(str): The Amazon Resource Name (ARN) of the work team for which you want to see labeling jobs for.
        max_results(int, optional): The maximum number of labeling jobs to return in each page of the response. Defaults to None.
        next_token(str, optional): If the result of the previous ListLabelingJobsForWorkteam request was truncated, the response includes a NextToken. To retrieve the next set of labeling jobs, use the token in the next request. Defaults to None.
        creation_time_after(str, optional): A filter that returns only labeling jobs created after the specified time (timestamp). Defaults to None.
        creation_time_before(str, optional): A filter that returns only labeling jobs created before the specified time (timestamp). Defaults to None.
        job_reference_code_contains(str, optional): A filter the limits jobs to only the ones whose job reference code contains the specified string. Defaults to None.
        sort_by(str, optional): The field to sort results by. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Ascending. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.labeling_jobs_for_workteam.list(
                ctx, workteam_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.labeling_jobs_for_workteam.list workteam_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_labeling_jobs_for_workteam",
        op_kwargs={
            "WorkteamArn": workteam_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "JobReferenceCodeContains": job_reference_code_contains,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )
