"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def search(
    hub,
    ctx,
    resource: str,
    search_expression: Dict = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Finds Amazon SageMaker resources that match a search query. Matching resources are returned as a list of SearchRecord objects in the response. You can sort the search results by any resource property in a ascending or descending order. You can query against the following value types: numeric, text, Boolean, and timestamp.

    Args:
        resource(str): The name of the Amazon SageMaker resource to search for.
        search_expression(Dict, optional): A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You must provide at least one subexpression, filter, or nested filter. The maximum number of recursive SubExpressions, NestedFilters, and Filters that can be included in a SearchExpression object is 50. Defaults to None.
        sort_by(str, optional): The name of the resource property used to sort the SearchResults. The default is LastModifiedTime. Defaults to None.
        sort_order(str, optional): How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending. Defaults to None.
        next_token(str, optional): If more than MaxResults resources match the specified SearchExpression, the response includes a NextToken. The NextToken can be passed to the next SearchRequest to continue retrieving results. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.init.search(ctx, resource=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.init.search resource=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="search",
        op_kwargs={
            "Resource": resource,
            "SearchExpression": search_expression,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
