"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, base_image: str, client_token: str, image_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a version of the SageMaker image specified by ImageName. The version represents the Amazon Container Registry (ECR) container image specified by BaseImage.

    Args:
        base_image(str): The registry path of the container image to use as the starting point for this version. The path is an Amazon Container Registry (ECR) URI in the following format:  <acct-id>.dkr.ecr.<region>.amazonaws.com/<repo-name[:tag] or [@digest]> .
        client_token(str): A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for Python (Boto3), add a unique value to the call.
        image_name(str): The ImageName of the Image to create a version of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.image.version.create(
                ctx, base_image=value, client_token=value, image_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.image.version.create base_image=value, client_token=value, image_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_image_version",
        op_kwargs={
            "BaseImage": base_image,
            "ClientToken": client_token,
            "ImageName": image_name,
        },
    )


async def delete(hub, ctx, image_name: str, version: int) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a version of a SageMaker image. The container image the version represents isn't deleted.

    Args:
        image_name(str): The name of the image.
        version(int): The version to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.image.version.delete(
                ctx, image_name=value, version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.image.version.delete image_name=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_image_version",
        op_kwargs={"ImageName": image_name, "Version": version},
    )


async def describe(hub, ctx, image_name: str, version: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes a version of a SageMaker image.

    Args:
        image_name(str): The name of the image.
        version(int, optional): The version of the image. If not specified, the latest version is described. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.image.version.describe(ctx, image_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.image.version.describe image_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_image_version",
        op_kwargs={"ImageName": image_name, "Version": version},
    )


async def list_all(
    hub,
    ctx,
    image_name: str,
    creation_time_after: str = None,
    creation_time_before: str = None,
    last_modified_time_after: str = None,
    last_modified_time_before: str = None,
    max_results: int = None,
    next_token: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of a specified image and their properties. The list can be filtered by creation time or modified time.

    Args:
        creation_time_after(str, optional): A filter that returns only versions created on or after the specified time. Defaults to None.
        creation_time_before(str, optional): A filter that returns only versions created on or before the specified time. Defaults to None.
        image_name(str): The name of the image to list the versions of.
        last_modified_time_after(str, optional): A filter that returns only versions modified on or after the specified time. Defaults to None.
        last_modified_time_before(str, optional): A filter that returns only versions modified on or before the specified time. Defaults to None.
        max_results(int, optional): The maximum number of versions to return in the response. The default value is 10. . Defaults to None.
        next_token(str, optional): If the previous call to ListImageVersions didn't return the full set of versions, the call returns a token for getting the next set of versions. Defaults to None.
        sort_by(str, optional): The property used to sort results. The default value is CREATION_TIME. Defaults to None.
        sort_order(str, optional): The sort order. The default value is DESCENDING. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.image.version.list_all(ctx, image_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.image.version.list_all image_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_image_versions",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "ImageName": image_name,
            "LastModifiedTimeAfter": last_modified_time_after,
            "LastModifiedTimeBefore": last_modified_time_before,
            "MaxResults": max_results,
            "NextToken": next_token,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )
