"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    image_name: str,
    role_arn: str,
    description: str = None,
    display_name: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon Container Registry (ECR). For more information, see Bring your own SageMaker image.

    Args:
        description(str, optional): The description of the image. Defaults to None.
        display_name(str, optional): The display name of the image. If not provided, ImageName is displayed. Defaults to None.
        image_name(str): The name of the image. Must be unique to your account.
        role_arn(str): The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
        tags(List, optional): A list of tags to apply to the image. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.image.init.create(
                ctx, image_name=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.image.init.create image_name=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_image",
        op_kwargs={
            "Description": description,
            "DisplayName": display_name,
            "ImageName": image_name,
            "RoleArn": role_arn,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, image_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a SageMaker image and all versions of the image. The container images aren't deleted.

    Args:
        image_name(str): The name of the image to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.image.init.delete(ctx, image_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.image.init.delete image_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_image",
        op_kwargs={"ImageName": image_name},
    )


async def describe(hub, ctx, image_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a SageMaker image.

    Args:
        image_name(str): The name of the image to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.image.init.describe(ctx, image_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.image.init.describe image_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_image",
        op_kwargs={"ImageName": image_name},
    )


async def list_all(
    hub,
    ctx,
    creation_time_after: str = None,
    creation_time_before: str = None,
    last_modified_time_after: str = None,
    last_modified_time_before: str = None,
    max_results: int = None,
    name_contains: str = None,
    next_token: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the images in your account and their properties. The list can be filtered by creation time or modified time, and whether the image name contains a specified string.

    Args:
        creation_time_after(str, optional): A filter that returns only images created on or after the specified time. Defaults to None.
        creation_time_before(str, optional): A filter that returns only images created on or before the specified time. Defaults to None.
        last_modified_time_after(str, optional): A filter that returns only images modified on or after the specified time. Defaults to None.
        last_modified_time_before(str, optional): A filter that returns only images modified on or before the specified time. Defaults to None.
        max_results(int, optional): The maximum number of images to return in the response. The default value is 10. . Defaults to None.
        name_contains(str, optional): A filter that returns only images whose name contains the specified string. Defaults to None.
        next_token(str, optional): If the previous call to ListImages didn't return the full set of images, the call returns a token for getting the next set of images. Defaults to None.
        sort_by(str, optional): The property used to sort results. The default value is CREATION_TIME. Defaults to None.
        sort_order(str, optional): The sort order. The default value is DESCENDING. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.image.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.image.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_images",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "LastModifiedTimeAfter": last_modified_time_after,
            "LastModifiedTimeBefore": last_modified_time_before,
            "MaxResults": max_results,
            "NameContains": name_contains,
            "NextToken": next_token,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )


async def update(
    hub,
    ctx,
    image_name: str,
    delete_properties: List = None,
    description: str = None,
    display_name: str = None,
    role_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the properties of a SageMaker image. To change the image's tags, use the AddTags and DeleteTags APIs.

    Args:
        delete_properties(List, optional): A list of properties to delete. Only the Description and DisplayName properties can be deleted. Defaults to None.
        description(str, optional): The new description for the image. Defaults to None.
        display_name(str, optional): The new display name for the image. Defaults to None.
        image_name(str): The name of the image to update.
        role_arn(str, optional): The new Amazon Resource Name (ARN) for the IAM role that enables Amazon SageMaker to perform tasks on your behalf. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.image.init.update(ctx, image_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.image.init.update image_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_image",
        op_kwargs={
            "DeleteProperties": delete_properties,
            "Description": description,
            "DisplayName": display_name,
            "ImageName": image_name,
            "RoleArn": role_arn,
        },
    )
