"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    hyper_parameter_tuning_job_name: str,
    hyper_parameter_tuning_job_config: Dict,
    training_job_definition: Dict = None,
    training_job_definitions: List = None,
    warm_start_config: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured by an objective metric that you choose.

    Args:
        hyper_parameter_tuning_job_name(str): The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.
        hyper_parameter_tuning_job_config(Dict): The HyperParameterTuningJobConfig object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see How Hyperparameter Tuning Works.
        training_job_definition(Dict, optional): The HyperParameterTrainingJobDefinition object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition. Defaults to None.
        training_job_definitions(List, optional): A list of the HyperParameterTrainingJobDefinition objects launched for this tuning job. Defaults to None.
        warm_start_config(Dict, optional): Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job. All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify IDENTICAL_DATA_AND_ALGORITHM as the WarmStartType value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.  All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job. . Defaults to None.
        tags(List, optional): An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see Tagging Amazon Web Services Resources. Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.hyper_parameter_tuning_job.create(
                ctx, hyper_parameter_tuning_job_name=value, hyper_parameter_tuning_job_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.hyper_parameter_tuning_job.create hyper_parameter_tuning_job_name=value, hyper_parameter_tuning_job_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_hyper_parameter_tuning_job",
        op_kwargs={
            "HyperParameterTuningJobName": hyper_parameter_tuning_job_name,
            "HyperParameterTuningJobConfig": hyper_parameter_tuning_job_config,
            "TrainingJobDefinition": training_job_definition,
            "TrainingJobDefinitions": training_job_definitions,
            "WarmStartConfig": warm_start_config,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, hyper_parameter_tuning_job_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a description of a hyperparameter tuning job.

    Args:
        hyper_parameter_tuning_job_name(str): The name of the tuning job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.hyper_parameter_tuning_job.describe(
                ctx, hyper_parameter_tuning_job_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.hyper_parameter_tuning_job.describe hyper_parameter_tuning_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_hyper_parameter_tuning_job",
        op_kwargs={"HyperParameterTuningJobName": hyper_parameter_tuning_job_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    sort_by: str = None,
    sort_order: str = None,
    name_contains: str = None,
    creation_time_after: str = None,
    creation_time_before: str = None,
    last_modified_time_after: str = None,
    last_modified_time_before: str = None,
    status_equals: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of HyperParameterTuningJobSummary objects that describe the hyperparameter tuning jobs launched in your account.

    Args:
        next_token(str, optional): If the result of the previous ListHyperParameterTuningJobs request was truncated, the response includes a NextToken. To retrieve the next set of tuning jobs, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of tuning jobs to return. The default value is 10. Defaults to None.
        sort_by(str, optional): The field to sort results by. The default is Name. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Ascending. Defaults to None.
        name_contains(str, optional): A string in the tuning job name. This filter returns only tuning jobs whose name contains the specified string. Defaults to None.
        creation_time_after(str, optional): A filter that returns only tuning jobs that were created after the specified time. Defaults to None.
        creation_time_before(str, optional): A filter that returns only tuning jobs that were created before the specified time. Defaults to None.
        last_modified_time_after(str, optional): A filter that returns only tuning jobs that were modified after the specified time. Defaults to None.
        last_modified_time_before(str, optional): A filter that returns only tuning jobs that were modified before the specified time. Defaults to None.
        status_equals(str, optional): A filter that returns only tuning jobs with the specified status. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.hyper_parameter_tuning_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.hyper_parameter_tuning_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_hyper_parameter_tuning_jobs",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NameContains": name_contains,
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "LastModifiedTimeAfter": last_modified_time_after,
            "LastModifiedTimeBefore": last_modified_time_before,
            "StatusEquals": status_equals,
        },
    )


async def stop(hub, ctx, hyper_parameter_tuning_job_name: str) -> None:
    r"""
    **Autogenerated function**

    Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched. All model artifacts output from the training jobs are stored in Amazon Simple Storage Service (Amazon S3). All data that the training jobs write to Amazon CloudWatch Logs are still available in CloudWatch. After the tuning job moves to the Stopped state, it releases all reserved resources for the tuning job.

    Args:
        hyper_parameter_tuning_job_name(str): The name of the tuning job to stop.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.hyper_parameter_tuning_job.stop(
                ctx, hyper_parameter_tuning_job_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.hyper_parameter_tuning_job.stop hyper_parameter_tuning_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="stop_hyper_parameter_tuning_job",
        op_kwargs={"HyperParameterTuningJobName": hyper_parameter_tuning_job_name},
    )
