"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    creation_time_after: str = None,
    creation_time_before: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the human task user interfaces in your account.

    Args:
        creation_time_after(str, optional): A filter that returns only human task user interfaces with a creation time greater than or equal to the specified timestamp. Defaults to None.
        creation_time_before(str, optional): A filter that returns only human task user interfaces that were created before the specified timestamp. Defaults to None.
        sort_order(str, optional): An optional value that specifies whether you want the results sorted in Ascending or Descending order. Defaults to None.
        next_token(str, optional): A token to resume pagination. Defaults to None.
        max_results(int, optional): The total number of items to return. If the total number of available items is more than the value specified in MaxResults, then a NextToken will be provided in the output that you can use to resume pagination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.human_task_uis.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.human_task_uis.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_human_task_uis",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
