"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, human_task_ui_name: str, ui_template: Dict, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel interface with an instruction area, the item to review, and an input area.

    Args:
        human_task_ui_name(str): The name of the user interface you are creating.
        ui_template(Dict): The Liquid template for the worker user interface.
        tags(List, optional): An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow user interface. Each tag consists of a key and a value, both of which you define. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.human_task_ui.create(
                ctx, human_task_ui_name=value, ui_template=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.human_task_ui.create human_task_ui_name=value, ui_template=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_human_task_ui",
        op_kwargs={
            "HumanTaskUiName": human_task_ui_name,
            "UiTemplate": ui_template,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, human_task_ui_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Use this operation to delete a human task user interface (worker task template).  To see a list of human task user interfaces (work task templates) in your account, use . When you delete a worker task template, it no longer appears when you call ListHumanTaskUis.

    Args:
        human_task_ui_name(str): The name of the human task user interface (work task template) you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.human_task_ui.delete(ctx, human_task_ui_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.human_task_ui.delete human_task_ui_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_human_task_ui",
        op_kwargs={"HumanTaskUiName": human_task_ui_name},
    )


async def describe(hub, ctx, human_task_ui_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the requested human task user interface (worker task template).

    Args:
        human_task_ui_name(str): The name of the human task user interface (worker task template) you want information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.human_task_ui.describe(ctx, human_task_ui_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.human_task_ui.describe human_task_ui_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_human_task_ui",
        op_kwargs={"HumanTaskUiName": human_task_ui_name},
    )
