"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    flow_definition_name: str,
    human_loop_config: Dict,
    output_config: Dict,
    role_arn: str,
    human_loop_request_source: Dict = None,
    human_loop_activation_config: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a flow definition.

    Args:
        flow_definition_name(str): The name of your flow definition.
        human_loop_request_source(Dict, optional): Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. Defaults to None.
        human_loop_activation_config(Dict, optional): An object containing information about the events that trigger a human workflow. Defaults to None.
        human_loop_config(Dict): An object containing information about the tasks the human reviewers will perform.
        output_config(Dict): An object containing information about where the human review results will be uploaded.
        role_arn(str): The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example, arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298.
        tags(List, optional): An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag consists of a key and a value, both of which you define. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.flow_definition.create(
                ctx,
                flow_definition_name=value,
                human_loop_config=value,
                output_config=value,
                role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.flow_definition.create flow_definition_name=value, human_loop_config=value, output_config=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_flow_definition",
        op_kwargs={
            "FlowDefinitionName": flow_definition_name,
            "HumanLoopRequestSource": human_loop_request_source,
            "HumanLoopActivationConfig": human_loop_activation_config,
            "HumanLoopConfig": human_loop_config,
            "OutputConfig": output_config,
            "RoleArn": role_arn,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, flow_definition_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified flow definition.

    Args:
        flow_definition_name(str): The name of the flow definition you are deleting.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.flow_definition.delete(
                ctx, flow_definition_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.flow_definition.delete flow_definition_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_flow_definition",
        op_kwargs={"FlowDefinitionName": flow_definition_name},
    )


async def describe(hub, ctx, flow_definition_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified flow definition.

    Args:
        flow_definition_name(str): The name of the flow definition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.flow_definition.describe(
                ctx, flow_definition_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.flow_definition.describe flow_definition_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_flow_definition",
        op_kwargs={"FlowDefinitionName": flow_definition_name},
    )


async def list_all(
    hub,
    ctx,
    creation_time_after: str = None,
    creation_time_before: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the flow definitions in your account.

    Args:
        creation_time_after(str, optional): A filter that returns only flow definitions with a creation time greater than or equal to the specified timestamp. Defaults to None.
        creation_time_before(str, optional): A filter that returns only flow definitions that were created before the specified timestamp. Defaults to None.
        sort_order(str, optional): An optional value that specifies whether you want the results sorted in Ascending or Descending order. Defaults to None.
        next_token(str, optional): A token to resume pagination. Defaults to None.
        max_results(int, optional): The total number of items to return. If the total number of available items is more than the value specified in MaxResults, then a NextToken will be provided in the output that you can use to resume pagination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.flow_definition.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.flow_definition.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_flow_definitions",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
