"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    feature_group_name: str,
    record_identifier_feature_name: str,
    event_time_feature_name: str,
    feature_definitions: List,
    online_store_config: Dict = None,
    offline_store_config: Dict = None,
    role_arn: str = None,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new FeatureGroup. A FeatureGroup is a group of Features defined in the FeatureStore to describe a Record.  The FeatureGroup defines the schema and features contained in the FeatureGroup. A FeatureGroup definition is composed of a list of Features, a RecordIdentifierFeatureName, an EventTimeFeatureName and configurations for its OnlineStore and OfflineStore. Check Amazon Web Services service quotas to see the FeatureGroups quota for your Amazon Web Services account.  You must include at least one of OnlineStoreConfig and OfflineStoreConfig to create a FeatureGroup.

    Args:
        feature_group_name(str): The name of the FeatureGroup. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. The name:   Must start and end with an alphanumeric character.   Can only contain alphanumeric character and hyphens. Spaces are not allowed.   .
        record_identifier_feature_name(str): The name of the Feature whose value uniquely identifies a Record defined in the FeatureStore. Only the latest record per identifier value will be stored in the OnlineStore. RecordIdentifierFeatureName must be one of feature definitions' names. You use the RecordIdentifierFeatureName to access data in a FeatureStore. This name:   Must start and end with an alphanumeric character.   Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed.   .
        event_time_feature_name(str): The name of the feature that stores the EventTime of a Record in a FeatureGroup. An EventTime is a point in time when a new event occurs that corresponds to the creation or update of a Record in a FeatureGroup. All Records in the FeatureGroup must have a corresponding EventTime. An EventTime can be a String or Fractional.     Fractional: EventTime feature values must be a Unix timestamp in seconds.    String: EventTime feature values must be an ISO-8601 string in the format. The following formats are supported yyyy-MM-dd'T'HH:mm:ssZ and yyyy-MM-dd'T'HH:mm:ss.SSSZ where yyyy, MM, and dd represent the year, month, and day respectively and HH, mm, ss, and if applicable, SSS represent the hour, month, second and milliseconds respsectively. 'T' and Z are constants.  .
        feature_definitions(List): A list of Feature names and types. Name and Type is compulsory per Feature.  Valid feature FeatureTypes are Integral, Fractional and String.  FeatureNames cannot be any of the following: is_deleted, write_time, api_invocation_time  You can create up to 2,500 FeatureDefinitions per FeatureGroup.
        online_store_config(Dict, optional): You can turn the OnlineStore on or off by specifying True for the EnableOnlineStore flag in OnlineStoreConfig; the default value is False. You can also include an Amazon Web Services KMS key ID (KMSKeyId) for at-rest encryption of the OnlineStore. Defaults to None.
        offline_store_config(Dict, optional): Use this to configure an OfflineFeatureStore. This parameter allows you to specify:   The Amazon Simple Storage Service (Amazon S3) location of an OfflineStore.   A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data cataolgue.    An KMS encryption key to encrypt the Amazon S3 location used for OfflineStore.   To learn more about this parameter, see OfflineStoreConfig. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the OfflineStore if an OfflineStoreConfig is provided. Defaults to None.
        description(str, optional): A free-form description of a FeatureGroup. Defaults to None.
        tags(List, optional): Tags used to identify Features in each FeatureGroup. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.feature_group.create(
                ctx,
                feature_group_name=value,
                record_identifier_feature_name=value,
                event_time_feature_name=value,
                feature_definitions=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.feature_group.create feature_group_name=value, record_identifier_feature_name=value, event_time_feature_name=value, feature_definitions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_feature_group",
        op_kwargs={
            "FeatureGroupName": feature_group_name,
            "RecordIdentifierFeatureName": record_identifier_feature_name,
            "EventTimeFeatureName": event_time_feature_name,
            "FeatureDefinitions": feature_definitions,
            "OnlineStoreConfig": online_store_config,
            "OfflineStoreConfig": offline_store_config,
            "RoleArn": role_arn,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, feature_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Delete the FeatureGroup and any data that was written to the OnlineStore of the FeatureGroup. Data cannot be accessed from the OnlineStore immediately after DeleteFeatureGroup is called.  Data written into the OfflineStore will not be deleted. The Amazon Web Services Glue database and tables that are automatically created for your OfflineStore are not deleted.

    Args:
        feature_group_name(str): The name of the FeatureGroup you want to delete. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.feature_group.delete(ctx, feature_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.feature_group.delete feature_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_feature_group",
        op_kwargs={"FeatureGroupName": feature_group_name},
    )


async def describe(hub, ctx, feature_group_name: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Use this operation to describe a FeatureGroup. The response includes information on the creation time, FeatureGroup name, the unique identifier for each FeatureGroup, and more.

    Args:
        feature_group_name(str): The name of the FeatureGroup you want described. .
        next_token(str, optional): A token to resume pagination of the list of Features (FeatureDefinitions). 2,500 Features are returned by default. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.feature_group.describe(ctx, feature_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.feature_group.describe feature_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_feature_group",
        op_kwargs={"FeatureGroupName": feature_group_name, "NextToken": next_token},
    )


async def list_all(
    hub,
    ctx,
    name_contains: str = None,
    feature_group_status_equals: str = None,
    offline_store_status_equals: str = None,
    creation_time_after: str = None,
    creation_time_before: str = None,
    sort_order: str = None,
    sort_by: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List FeatureGroups based on given filter and order.

    Args:
        name_contains(str, optional): A string that partially matches one or more FeatureGroups names. Filters FeatureGroups by name. . Defaults to None.
        feature_group_status_equals(str, optional): A FeatureGroup status. Filters by FeatureGroup status. . Defaults to None.
        offline_store_status_equals(str, optional): An OfflineStore status. Filters by OfflineStore status. . Defaults to None.
        creation_time_after(str, optional): Use this parameter to search for FeatureGroupss created after a specific date and time. Defaults to None.
        creation_time_before(str, optional): Use this parameter to search for FeatureGroupss created before a specific date and time. Defaults to None.
        sort_order(str, optional): The order in which feature groups are listed. Defaults to None.
        sort_by(str, optional): The value on which the feature group list is sorted. Defaults to None.
        max_results(int, optional): The maximum number of results returned by ListFeatureGroups. Defaults to None.
        next_token(str, optional): A token to resume pagination of ListFeatureGroups results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.feature_group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.feature_group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_feature_groups",
        op_kwargs={
            "NameContains": name_contains,
            "FeatureGroupStatusEquals": feature_group_status_equals,
            "OfflineStoreStatusEquals": offline_store_status_equals,
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "SortOrder": sort_order,
            "SortBy": sort_by,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
