"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    experiment_name: str,
    display_name: str = None,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an SageMaker experiment. An experiment is a collection of trials that are observed, compared and evaluated as a group. A trial is a set of steps, called trial components, that produce a machine learning model. The goal of an experiment is to determine the components that produce the best model. Multiple trials are performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the remaining inputs constant. When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK. You can add tags to experiments, trials, trial components and then use the Search API to search for the tags. To add a description to an experiment, specify the optional Description parameter. To add a description later, or to change the description, call the UpdateExperiment API. To get a list of all your experiments, call the ListExperiments API. To view an experiment's properties, call the DescribeExperiment API. To get a list of all the trials associated with an experiment, call the ListTrials API. To create a trial call the CreateTrial API.

    Args:
        experiment_name(str): The name of the experiment. The name must be unique in your Amazon Web Services account and is not case-sensitive.
        display_name(str, optional): The name of the experiment as displayed. The name doesn't need to be unique. If you don't specify DisplayName, the value in ExperimentName is displayed. Defaults to None.
        description(str, optional): The description of the experiment. Defaults to None.
        tags(List, optional): A list of tags to associate with the experiment. You can use Search API to search on the tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.experiment.create(ctx, experiment_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.experiment.create experiment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_experiment",
        op_kwargs={
            "ExperimentName": experiment_name,
            "DisplayName": display_name,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, experiment_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the ListTrials API to get a list of the trials associated with the experiment.

    Args:
        experiment_name(str): The name of the experiment to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.experiment.delete(ctx, experiment_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.experiment.delete experiment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_experiment",
        op_kwargs={"ExperimentName": experiment_name},
    )


async def describe(hub, ctx, experiment_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of an experiment's properties.

    Args:
        experiment_name(str): The name of the experiment to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.experiment.describe(ctx, experiment_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.experiment.describe experiment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_experiment",
        op_kwargs={"ExperimentName": experiment_name},
    )


async def list_all(
    hub,
    ctx,
    created_after: str = None,
    created_before: str = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the experiments in your account. The list can be filtered to show only experiments that were created in a specific time range. The list can be sorted by experiment name or creation time.

    Args:
        created_after(str, optional): A filter that returns only experiments created after the specified time. Defaults to None.
        created_before(str, optional): A filter that returns only experiments created before the specified time. Defaults to None.
        sort_by(str, optional): The property used to sort results. The default value is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order. The default value is Descending. Defaults to None.
        next_token(str, optional): If the previous call to ListExperiments didn't return the full set of experiments, the call returns a token for getting the next set of experiments. Defaults to None.
        max_results(int, optional): The maximum number of experiments to return in the response. The default value is 10. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.experiment.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.experiment.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_experiments",
        op_kwargs={
            "CreatedAfter": created_after,
            "CreatedBefore": created_before,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub, ctx, experiment_name: str, display_name: str = None, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Adds, updates, or removes the description of an experiment. Updates the display name of an experiment.

    Args:
        experiment_name(str): The name of the experiment to update.
        display_name(str, optional): The name of the experiment as displayed. The name doesn't need to be unique. If DisplayName isn't specified, ExperimentName is displayed. Defaults to None.
        description(str, optional): The description of the experiment. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.experiment.update(ctx, experiment_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.experiment.update experiment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_experiment",
        op_kwargs={
            "ExperimentName": experiment_name,
            "DisplayName": display_name,
            "Description": description,
        },
    )
