"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, endpoint_name: str, endpoint_config_name: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an endpoint using the endpoint configuration specified in the request. Amazon SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the CreateEndpointConfig API.   Use this API to deploy models using Amazon SageMaker hosting services.  For an example that calls this method when deploying a model to Amazon SageMaker hosting services, see the Create Endpoint example notebook.    You must not delete an EndpointConfig that is in use by an endpoint that is live or while the UpdateEndpoint or CreateEndpoint operations are being performed on the endpoint. To update an endpoint, you must create a new EndpointConfig.  The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.  When it receives the request, Amazon SageMaker creates the endpoint, launches the resources (ML compute instances), and deploys the model(s) on them.   When you call CreateEndpoint, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting  Eventually Consistent Reads , the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call DescribeEndpointConfig before calling CreateEndpoint to minimize the potential impact of a DynamoDB eventually consistent read.  When Amazon SageMaker receives the request, it sets the endpoint status to Creating. After it creates the endpoint, it sets the status to InService. Amazon SageMaker can then process incoming requests for inferences. To check the status of an endpoint, use the DescribeEndpoint API. If any of the models hosted at this endpoint get model data from an Amazon S3 location, Amazon SageMaker uses Amazon Web Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information, see Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region in the Amazon Web Services Identity and Access Management User Guide.   To add the IAM role policies for using this API operation, go to the IAM console, and choose Roles in the left navigation pane. Search the IAM role that you want to grant access to use the CreateEndpoint and CreateEndpointConfig API operations, add the following policies to the role.    Option 1: For a full Amazon SageMaker access, search and attach the AmazonSageMakerFullAccess policy.   Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the JSON file of the IAM role:   "Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]   "Resource": [   "arn:aws:sagemaker:region:account-id:endpoint/endpointName"   "arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"   ]  For more information, see Amazon SageMaker API Permissions: Actions, Permissions, and Resources Reference.

    Args:
        endpoint_name(str): The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon Web Services account. The name is case-insensitive in CreateEndpoint, but the case is preserved and must be matched in .
        endpoint_config_name(str): The name of an endpoint configuration. For more information, see CreateEndpointConfig. .
        tags(List, optional): An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see Tagging Amazon Web Services Resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.endpoint.init.create(
                ctx, endpoint_name=value, endpoint_config_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.endpoint.init.create endpoint_name=value, endpoint_config_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_endpoint",
        op_kwargs={
            "EndpointName": endpoint_name,
            "EndpointConfigName": endpoint_config_name,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, endpoint_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an endpoint. Amazon SageMaker frees up all of the resources that were deployed when the endpoint was created.  Amazon SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the RevokeGrant API call.

    Args:
        endpoint_name(str): The name of the endpoint that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.endpoint.init.delete(ctx, endpoint_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.endpoint.init.delete endpoint_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_endpoint",
        op_kwargs={"EndpointName": endpoint_name},
    )


async def describe(hub, ctx, endpoint_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the description of an endpoint.

    Args:
        endpoint_name(str): The name of the endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.endpoint.init.describe(ctx, endpoint_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.endpoint.init.describe endpoint_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_endpoint",
        op_kwargs={"EndpointName": endpoint_name},
    )


async def list_all(
    hub,
    ctx,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
    name_contains: str = None,
    creation_time_before: str = None,
    creation_time_after: str = None,
    last_modified_time_before: str = None,
    last_modified_time_after: str = None,
    status_equals: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists endpoints.

    Args:
        sort_by(str, optional): Sorts the list of results. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Descending. Defaults to None.
        next_token(str, optional): If the result of a ListEndpoints request was truncated, the response includes a NextToken. To retrieve the next set of endpoints, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of endpoints to return in the response. This value defaults to 10. Defaults to None.
        name_contains(str, optional): A string in endpoint names. This filter returns only endpoints whose name contains the specified string. Defaults to None.
        creation_time_before(str, optional): A filter that returns only endpoints that were created before the specified time (timestamp). Defaults to None.
        creation_time_after(str, optional): A filter that returns only endpoints with a creation time greater than or equal to the specified time (timestamp). Defaults to None.
        last_modified_time_before(str, optional):  A filter that returns only endpoints that were modified before the specified timestamp. . Defaults to None.
        last_modified_time_after(str, optional):  A filter that returns only endpoints that were modified after the specified timestamp. . Defaults to None.
        status_equals(str, optional):  A filter that returns only endpoints with the specified status. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.endpoint.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.endpoint.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_endpoints",
        op_kwargs={
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
            "NameContains": name_contains,
            "CreationTimeBefore": creation_time_before,
            "CreationTimeAfter": creation_time_after,
            "LastModifiedTimeBefore": last_modified_time_before,
            "LastModifiedTimeAfter": last_modified_time_after,
            "StatusEquals": status_equals,
        },
    )


async def update(
    hub,
    ctx,
    endpoint_name: str,
    endpoint_config_name: str,
    retain_all_variant_properties: bool = None,
    exclude_retained_variant_properties: List = None,
    deployment_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deploys the new EndpointConfig specified in the request, switches to using newly created endpoint, and then deletes resources provisioned for the endpoint using the previous EndpointConfig (there is no availability loss).  When Amazon SageMaker receives the request, it sets the endpoint status to Updating. After updating the endpoint, it sets the status to InService. To check the status of an endpoint, use the DescribeEndpoint API.   You must not delete an EndpointConfig in use by an endpoint that is live or while the UpdateEndpoint or CreateEndpoint operations are being performed on the endpoint. To update an endpoint, you must create a new EndpointConfig. If you delete the EndpointConfig of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.

    Args:
        endpoint_name(str): The name of the endpoint whose configuration you want to update.
        endpoint_config_name(str): The name of the new endpoint configuration.
        retain_all_variant_properties(bool, optional): When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set RetainAllVariantProperties to true. To use the variant properties specified in a new EndpointConfig call when updating an endpoint, set RetainAllVariantProperties to false. The default is false. Defaults to None.
        exclude_retained_variant_properties(List, optional): When you are updating endpoint resources with UpdateEndpointInput$RetainAllVariantProperties, whose value is set to true, ExcludeRetainedVariantProperties specifies the list of type VariantProperty to override with the values provided by EndpointConfig. If you don't specify a value for ExcludeAllVariantProperties, no variant properties are overridden. . Defaults to None.
        deployment_config(Dict, optional): The deployment configuration for the endpoint to be updated. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.endpoint.init.update(
                ctx, endpoint_name=value, endpoint_config_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.endpoint.init.update endpoint_name=value, endpoint_config_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_endpoint",
        op_kwargs={
            "EndpointName": endpoint_name,
            "EndpointConfigName": endpoint_config_name,
            "RetainAllVariantProperties": retain_all_variant_properties,
            "ExcludeRetainedVariantProperties": exclude_retained_variant_properties,
            "DeploymentConfig": deployment_config,
        },
    )
