"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    endpoint_config_name: str,
    production_variants: List,
    data_capture_config: Dict = None,
    tags: List = None,
    kms_key_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an endpoint configuration that Amazon SageMaker hosting services uses to deploy models. In the configuration, you identify one or more models, created using the CreateModel API, to deploy and the resources that you want Amazon SageMaker to provision. Then you call the CreateEndpoint API.   Use this API if you want to use Amazon SageMaker hosting services to deploy models into production.   In the request, you define a ProductionVariant, for each model that you want to deploy. Each ProductionVariant parameter also describes the resources that you want Amazon SageMaker to provision. This includes the number and type of ML compute instances to deploy.  If you are hosting multiple models, you also assign a VariantWeight to specify how much traffic you want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign traffic weight 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds of the traffic to Model A, and one-third to model B.  For an example that calls this method when deploying a model to Amazon SageMaker hosting services, see Deploy the Model to Amazon SageMaker Hosting Services (Amazon Web Services SDK for Python (Boto 3)).   When you call CreateEndpoint, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting  Eventually Consistent Reads , the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call DescribeEndpointConfig before calling CreateEndpoint to minimize the potential impact of a DynamoDB eventually consistent read.

    Args:
        endpoint_config_name(str): The name of the endpoint configuration. You specify this name in a CreateEndpoint request. .
        production_variants(List): An list of ProductionVariant objects, one for each model that you want to host at this endpoint.
        data_capture_config(Dict, optional): . Defaults to None.
        tags(List, optional): An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see Tagging Amazon Web Services Resources. Defaults to None.
        kms_key_id(str, optional): The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. The KmsKeyId can be any of the following formats:    Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    Alias name: alias/ExampleAlias    Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias    The KMS key policy must grant permission to the IAM role that you specify in your CreateEndpoint, UpdateEndpoint requests. For more information, refer to the Amazon Web Services Key Management Service section Using Key Policies in Amazon Web Services KMS    Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a KmsKeyId when using an instance type with local storage. If any of the models that you specify in the ProductionVariants parameter use nitro-based instances with local storage, do not specify a value for the KmsKeyId parameter. If you specify a value for KmsKeyId when using any nitro-based instances with local storage, the call to CreateEndpointConfig fails. For a list of instance types that support local instance storage, see Instance Store Volumes. For more information about local instance storage encryption, see SSD Instance Store Volumes. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.endpoint.config.create(
                ctx, endpoint_config_name=value, production_variants=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.endpoint.config.create endpoint_config_name=value, production_variants=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_endpoint_config",
        op_kwargs={
            "EndpointConfigName": endpoint_config_name,
            "ProductionVariants": production_variants,
            "DataCaptureConfig": data_capture_config,
            "Tags": tags,
            "KmsKeyId": kms_key_id,
        },
    )


async def delete(hub, ctx, endpoint_config_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an endpoint configuration. The DeleteEndpointConfig API deletes only the specified configuration. It does not delete endpoints created using the configuration.  You must not delete an EndpointConfig in use by an endpoint that is live or while the UpdateEndpoint or CreateEndpoint operations are being performed on the endpoint. If you delete the EndpointConfig of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.

    Args:
        endpoint_config_name(str): The name of the endpoint configuration that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.endpoint.config.delete(
                ctx, endpoint_config_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.endpoint.config.delete endpoint_config_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_endpoint_config",
        op_kwargs={"EndpointConfigName": endpoint_config_name},
    )


async def describe(hub, ctx, endpoint_config_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the description of an endpoint configuration created using the CreateEndpointConfig API.

    Args:
        endpoint_config_name(str): The name of the endpoint configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.endpoint.config.describe(
                ctx, endpoint_config_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.endpoint.config.describe endpoint_config_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_endpoint_config",
        op_kwargs={"EndpointConfigName": endpoint_config_name},
    )


async def list_all(
    hub,
    ctx,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
    name_contains: str = None,
    creation_time_before: str = None,
    creation_time_after: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists endpoint configurations.

    Args:
        sort_by(str, optional): The field to sort results by. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Descending. Defaults to None.
        next_token(str, optional): If the result of the previous ListEndpointConfig request was truncated, the response includes a NextToken. To retrieve the next set of endpoint configurations, use the token in the next request. . Defaults to None.
        max_results(int, optional): The maximum number of training jobs to return in the response. Defaults to None.
        name_contains(str, optional): A string in the endpoint configuration name. This filter returns only endpoint configurations whose name contains the specified string. . Defaults to None.
        creation_time_before(str, optional): A filter that returns only endpoint configurations created before the specified time (timestamp). Defaults to None.
        creation_time_after(str, optional): A filter that returns only endpoint configurations with a creation time greater than or equal to the specified time (timestamp). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.endpoint.config.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.endpoint.config.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_endpoint_configs",
        op_kwargs={
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
            "NameContains": name_contains,
            "CreationTimeBefore": creation_time_before,
            "CreationTimeAfter": creation_time_after,
        },
    )
