"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    domain_name: str,
    auth_mode: str,
    default_user_settings: Dict,
    subnet_ids: List,
    vpc_id: str,
    tags: List = None,
    app_network_access_type: str = None,
    home_efs_file_system_kms_key_id: str = None,
    kms_key_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Domain used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. An Amazon Web Services account is limited to one domain per region. Users within a domain can share notebook files and other artifacts with each other.  EFS storage  When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files. SageMaker uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS volume attached to the domain with an Amazon Web Services managed customer master key (CMK) by default. For more control, you can specify a customer managed CMK. For more information, see Protect Data at Rest Using Encryption.  VPC configuration  All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For other Studio traffic, you can specify the AppNetworkAccessType parameter. AppNetworkAccessType corresponds to the network access type that you choose when you onboard to Studio. The following options are available:    PublicInternetOnly - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.    VpcOnly - All Studio traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway. When internet access is disabled, you won't be able to run a Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.    NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a SageMaker Studio app successfully.  For more information, see Connect SageMaker Studio Notebooks to Resources in a VPC.

    Args:
        domain_name(str): A name for the domain.
        auth_mode(str): The mode of authentication that members use to access the domain.
        default_user_settings(Dict): The default settings to use to create a user profile when UserSettings isn't specified in the call to the CreateUserProfile API.  SecurityGroups is aggregated when specified in both calls. For all other settings in UserSettings, the values specified in CreateUserProfile take precedence over those specified in CreateDomain.
        subnet_ids(List): The VPC subnets that Studio uses for communication.
        vpc_id(str): The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
        tags(List, optional): Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. Tags that you specify for the Domain are also added to all Apps that the Domain launches. Defaults to None.
        app_network_access_type(str, optional): Specifies the VPC used for non-EFS traffic. The default value is PublicInternetOnly.    PublicInternetOnly - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access    VpcOnly - All Studio traffic is through the specified VPC and subnets  . Defaults to None.
        home_efs_file_system_kms_key_id(str, optional): This member is deprecated and replaced with KmsKeyId. Defaults to None.
        kms_key_id(str, optional): SageMaker uses Amazon Web Services KMS to encrypt the EFS volume attached to the domain with an Amazon Web Services managed customer master key (CMK) by default. For more control, specify a customer managed CMK. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.domain.create(
                ctx,
                domain_name=value,
                auth_mode=value,
                default_user_settings=value,
                subnet_ids=value,
                vpc_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.domain.create domain_name=value, auth_mode=value, default_user_settings=value, subnet_ids=value, vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_domain",
        op_kwargs={
            "DomainName": domain_name,
            "AuthMode": auth_mode,
            "DefaultUserSettings": default_user_settings,
            "SubnetIds": subnet_ids,
            "VpcId": vpc_id,
            "Tags": tags,
            "AppNetworkAccessType": app_network_access_type,
            "HomeEfsFileSystemKmsKeyId": home_efs_file_system_kms_key_id,
            "KmsKeyId": kms_key_id,
        },
    )


async def delete(hub, ctx, domain_id: str, retention_policy: Dict = None) -> None:
    r"""
    **Autogenerated function**

    Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again using SSO. Use with caution. All of the members of the domain will lose access to their EFS volume, including data, notebooks, and other artifacts.

    Args:
        domain_id(str): The domain ID.
        retention_policy(Dict, optional): The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained (not automatically deleted). . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.domain.delete(ctx, domain_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.domain.delete domain_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_domain",
        op_kwargs={"DomainId": domain_id, "RetentionPolicy": retention_policy},
    )


async def describe(hub, ctx, domain_id: str) -> Dict:
    r"""
    **Autogenerated function**

    The description of the domain.

    Args:
        domain_id(str): The domain ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.domain.describe(ctx, domain_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.domain.describe domain_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_domain",
        op_kwargs={"DomainId": domain_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the domains.

    Args:
        next_token(str, optional): If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results. Defaults to None.
        max_results(int, optional): Returns a list up to a specified limit. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.domain.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.domain.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_domains",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(hub, ctx, domain_id: str, default_user_settings: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the default settings for new user profiles in the domain.

    Args:
        domain_id(str): The ID of the domain to be updated.
        default_user_settings(Dict, optional): A collection of settings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.domain.update(ctx, domain_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.domain.update domain_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_domain",
        op_kwargs={"DomainId": domain_id, "DefaultUserSettings": default_user_settings},
    )
