"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(hub, ctx, device_fleet_name: str, device_names: List) -> None:
    r"""
    **Autogenerated function**

    Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.

    Args:
        device_fleet_name(str): The name of the fleet the devices belong to.
        device_names(List): The unique IDs of the devices.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.init.deregister(
                ctx, device_fleet_name=value, device_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.init.deregister device_fleet_name=value, device_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="deregister_devices",
        op_kwargs={"DeviceFleetName": device_fleet_name, "DeviceNames": device_names},
    )


async def describe(
    hub, ctx, device_name: str, device_fleet_name: str, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the device.

    Args:
        next_token(str, optional): Next token of device description. Defaults to None.
        device_name(str): The unique ID of the device.
        device_fleet_name(str): The name of the fleet the devices belong to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.init.describe(
                ctx, device_name=value, device_fleet_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.init.describe device_name=value, device_fleet_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_device",
        op_kwargs={
            "NextToken": next_token,
            "DeviceName": device_name,
            "DeviceFleetName": device_fleet_name,
        },
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    latest_heartbeat_after: str = None,
    model_name: str = None,
    device_fleet_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    A list of devices.

    Args:
        next_token(str, optional): The response from the last list when returning a list large enough to need tokening. Defaults to None.
        max_results(int, optional): Maximum number of results to select. Defaults to None.
        latest_heartbeat_after(str, optional): Select fleets where the job was updated after X. Defaults to None.
        model_name(str, optional): A filter that searches devices that contains this name in any of their models. Defaults to None.
        device_fleet_name(str, optional): Filter for fleets containing this name in their device fleet name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_devices",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "LatestHeartbeatAfter": latest_heartbeat_after,
            "ModelName": model_name,
            "DeviceFleetName": device_fleet_name,
        },
    )


async def register(
    hub, ctx, device_fleet_name: str, devices: List, tags: List = None
) -> None:
    r"""
    **Autogenerated function**

    Register devices.

    Args:
        device_fleet_name(str): The name of the fleet.
        devices(List): A list of devices to register with SageMaker Edge Manager.
        tags(List, optional): The tags associated with devices. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.init.register(
                ctx, device_fleet_name=value, devices=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.init.register device_fleet_name=value, devices=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="register_devices",
        op_kwargs={
            "DeviceFleetName": device_fleet_name,
            "Devices": devices,
            "Tags": tags,
        },
    )


async def update_multiple(hub, ctx, device_fleet_name: str, devices: List) -> None:
    r"""
    **Autogenerated function**

    Updates one or more devices in a fleet.

    Args:
        device_fleet_name(str): The name of the fleet the devices belong to.
        devices(List): List of devices to register with Edge Manager agent.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.init.update_multiple(
                ctx, device_fleet_name=value, devices=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.init.update_multiple device_fleet_name=value, devices=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_devices",
        op_kwargs={"DeviceFleetName": device_fleet_name, "Devices": devices},
    )
