"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, device_fleet_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a fleet.

    Args:
        device_fleet_name(str): The name of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.fleet.report.get(ctx, device_fleet_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.fleet.report.get device_fleet_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="get_device_fleet_report",
        op_kwargs={"DeviceFleetName": device_fleet_name},
    )
