"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    device_fleet_name: str,
    output_config: Dict,
    role_arn: str = None,
    description: str = None,
    tags: List = None,
    enable_iot_role_alias: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Creates a device fleet.

    Args:
        device_fleet_name(str): The name of the fleet that the device belongs to.
        role_arn(str, optional): The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT). Defaults to None.
        description(str, optional): A description of the fleet. Defaults to None.
        output_config(Dict): The output configuration for storing sample data collected by the fleet.
        tags(List, optional): Creates tags for the specified fleet. Defaults to None.
        enable_iot_role_alias(bool, optional): Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}". For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet". Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.fleet.init.create(
                ctx, device_fleet_name=value, output_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.fleet.init.create device_fleet_name=value, output_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_device_fleet",
        op_kwargs={
            "DeviceFleetName": device_fleet_name,
            "RoleArn": role_arn,
            "Description": description,
            "OutputConfig": output_config,
            "Tags": tags,
            "EnableIotRoleAlias": enable_iot_role_alias,
        },
    )


async def delete(hub, ctx, device_fleet_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a fleet.

    Args:
        device_fleet_name(str): The name of the fleet to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.fleet.init.delete(ctx, device_fleet_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.fleet.init.delete device_fleet_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_device_fleet",
        op_kwargs={"DeviceFleetName": device_fleet_name},
    )


async def describe(hub, ctx, device_fleet_name: str) -> Dict:
    r"""
    **Autogenerated function**

    A description of the fleet the device belongs to.

    Args:
        device_fleet_name(str): The name of the fleet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.fleet.init.describe(
                ctx, device_fleet_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.fleet.init.describe device_fleet_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_device_fleet",
        op_kwargs={"DeviceFleetName": device_fleet_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    creation_time_after: str = None,
    creation_time_before: str = None,
    last_modified_time_after: str = None,
    last_modified_time_before: str = None,
    name_contains: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of devices in the fleet.

    Args:
        next_token(str, optional): The response from the last list when returning a list large enough to need tokening. Defaults to None.
        max_results(int, optional): The maximum number of results to select. Defaults to None.
        creation_time_after(str, optional): Filter fleets where packaging job was created after specified time. Defaults to None.
        creation_time_before(str, optional): Filter fleets where the edge packaging job was created before specified time. Defaults to None.
        last_modified_time_after(str, optional): Select fleets where the job was updated after X. Defaults to None.
        last_modified_time_before(str, optional): Select fleets where the job was updated before X. Defaults to None.
        name_contains(str, optional): Filter for fleets containing this name in their fleet device name. Defaults to None.
        sort_by(str, optional): The column to sort by. Defaults to None.
        sort_order(str, optional): What direction to sort in. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.fleet.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.fleet.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_device_fleets",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "LastModifiedTimeAfter": last_modified_time_after,
            "LastModifiedTimeBefore": last_modified_time_before,
            "NameContains": name_contains,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )


async def update(
    hub,
    ctx,
    device_fleet_name: str,
    output_config: Dict,
    role_arn: str = None,
    description: str = None,
    enable_iot_role_alias: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates a fleet of devices.

    Args:
        device_fleet_name(str): The name of the fleet.
        role_arn(str, optional): The Amazon Resource Name (ARN) of the device. Defaults to None.
        description(str, optional): Description of the fleet. Defaults to None.
        output_config(Dict): Output configuration for storing sample data collected by the fleet.
        enable_iot_role_alias(bool, optional): Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}". For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet". Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.device.fleet.init.update(
                ctx, device_fleet_name=value, output_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.device.fleet.init.update device_fleet_name=value, output_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_device_fleet",
        op_kwargs={
            "DeviceFleetName": device_fleet_name,
            "RoleArn": role_arn,
            "Description": description,
            "OutputConfig": output_config,
            "EnableIotRoleAlias": enable_iot_role_alias,
        },
    )
