"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    compilation_job_name: str,
    role_arn: str,
    input_config: Dict,
    output_config: Dict,
    stopping_condition: Dict,
    vpc_config: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.  If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that case, deploy them as an ML resource. In the request body, you provide the following:   A name for the compilation job    Information about the input model artifacts    The output location for the compiled model and the device (target) that the model runs on    The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job.    You can also provide a Tag to track the model compilation job's resource use and costs. The response body contains the CompilationJobArn for the compiled job. To stop a model compilation job, use StopCompilationJob. To get information about a particular model compilation job, use DescribeCompilationJob. To get information about multiple model compilation jobs, use ListCompilationJobs.

    Args:
        compilation_job_name(str): A name for the model compilation job. The name must be unique within the Amazon Web Services Region and within your Amazon Web Services account. .
        role_arn(str): The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.  During model compilation, Amazon SageMaker needs your permission to:   Read input data from an S3 bucket   Write model artifacts to an S3 bucket   Write logs to Amazon CloudWatch Logs   Publish metrics to Amazon CloudWatch   You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the caller of this API must have the iam:PassRole permission. For more information, see Amazon SageMaker Roles. .
        input_config(Dict): Provides information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.
        output_config(Dict): Provides information about the output location for the compiled model and the target device the model runs on.
        vpc_config(Dict, optional): A VpcConfig object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see Protect Compilation Jobs by Using an Amazon Virtual Private Cloud. Defaults to None.
        stopping_condition(Dict): Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training costs.
        tags(List, optional): An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see Tagging Amazon Web Services Resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.compilation_job.create(
                ctx,
                compilation_job_name=value,
                role_arn=value,
                input_config=value,
                output_config=value,
                stopping_condition=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.compilation_job.create compilation_job_name=value, role_arn=value, input_config=value, output_config=value, stopping_condition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_compilation_job",
        op_kwargs={
            "CompilationJobName": compilation_job_name,
            "RoleArn": role_arn,
            "InputConfig": input_config,
            "OutputConfig": output_config,
            "VpcConfig": vpc_config,
            "StoppingCondition": stopping_condition,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, compilation_job_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a model compilation job. To create a model compilation job, use CreateCompilationJob. To get information about multiple model compilation jobs, use ListCompilationJobs.

    Args:
        compilation_job_name(str): The name of the model compilation job that you want information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.compilation_job.describe(
                ctx, compilation_job_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.compilation_job.describe compilation_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_compilation_job",
        op_kwargs={"CompilationJobName": compilation_job_name},
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    creation_time_after: str = None,
    creation_time_before: str = None,
    last_modified_time_after: str = None,
    last_modified_time_before: str = None,
    name_contains: str = None,
    status_equals: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists model compilation jobs that satisfy various filters. To create a model compilation job, use CreateCompilationJob. To get information about a particular model compilation job you have created, use DescribeCompilationJob.

    Args:
        next_token(str, optional): If the result of the previous ListCompilationJobs request was truncated, the response includes a NextToken. To retrieve the next set of model compilation jobs, use the token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of model compilation jobs to return in the response. Defaults to None.
        creation_time_after(str, optional): A filter that returns the model compilation jobs that were created after a specified time. . Defaults to None.
        creation_time_before(str, optional): A filter that returns the model compilation jobs that were created before a specified time. Defaults to None.
        last_modified_time_after(str, optional): A filter that returns the model compilation jobs that were modified after a specified time. Defaults to None.
        last_modified_time_before(str, optional): A filter that returns the model compilation jobs that were modified before a specified time. Defaults to None.
        name_contains(str, optional): A filter that returns the model compilation jobs whose name contains a specified string. Defaults to None.
        status_equals(str, optional): A filter that retrieves model compilation jobs with a specific DescribeCompilationJobResponse$CompilationJobStatus status. Defaults to None.
        sort_by(str, optional): The field by which to sort results. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for results. The default is Ascending. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.compilation_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.compilation_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_compilation_jobs",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "LastModifiedTimeAfter": last_modified_time_after,
            "LastModifiedTimeBefore": last_modified_time_before,
            "NameContains": name_contains,
            "StatusEquals": status_equals,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )


async def stop(hub, ctx, compilation_job_name: str) -> None:
    r"""
    **Autogenerated function**

    Stops a model compilation job.  To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This gracefully shuts the job down. If the job hasn't stopped, it sends the SIGKILL signal. When it receives a StopCompilationJob request, Amazon SageMaker changes the CompilationJobSummary$CompilationJobStatus of the job to Stopping. After Amazon SageMaker stops the job, it sets the CompilationJobSummary$CompilationJobStatus to Stopped.

    Args:
        compilation_job_name(str): The name of the model compilation job to stop.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.compilation_job.stop(ctx, compilation_job_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.compilation_job.stop compilation_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="stop_compilation_job",
        op_kwargs={"CompilationJobName": compilation_job_name},
    )
