"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    auto_ml_job_name: str,
    status_equals: str = None,
    candidate_name_equals: str = None,
    sort_order: str = None,
    sort_by: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the candidates created for the job.

    Args:
        auto_ml_job_name(str): List the candidates created for the job by providing the job's name.
        status_equals(str, optional): List the candidates for the job and filter by status. Defaults to None.
        candidate_name_equals(str, optional): List the candidates for the job and filter by candidate name. Defaults to None.
        sort_order(str, optional): The sort order for the results. The default is Ascending. Defaults to None.
        sort_by(str, optional): The parameter by which to sort the results. The default is Descending. Defaults to None.
        max_results(int, optional): List the job's candidates up to a specified limit. Defaults to None.
        next_token(str, optional): If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.candidate_for_auto_ml_job.list(
                ctx, auto_ml_job_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.candidate_for_auto_ml_job.list auto_ml_job_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_candidates_for_auto_ml_job",
        op_kwargs={
            "AutoMLJobName": auto_ml_job_name,
            "StatusEquals": status_equals,
            "CandidateNameEquals": candidate_name_equals,
            "SortOrder": sort_order,
            "SortBy": sort_by,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
