"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub, ctx, source_arn: str, destination_arn: str, association_type: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an association between the source and the destination. A source can be associated with multiple destinations, and a destination can be associated with multiple sources. An association is a lineage tracking entity. For more information, see Amazon SageMaker ML Lineage Tracking.

    Args:
        source_arn(str): The ARN of the source.
        destination_arn(str): The Amazon Resource Name (ARN) of the destination.
        association_type(str, optional): The type of association. The following are suggested uses for each type. Amazon SageMaker places no restrictions on their use.   ContributedTo - The source contributed to the destination or had a part in enabling the destination. For example, the training data contributed to the training job.   AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated with a model deployment.   DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel input for a processing job is derived from the original inputs.   Produced - The source generated the destination. For example, a training job produced a model artifact.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.association.add(
                ctx, source_arn=value, destination_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.association.add source_arn=value, destination_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="add_association",
        op_kwargs={
            "SourceArn": source_arn,
            "DestinationArn": destination_arn,
            "AssociationType": association_type,
        },
    )


async def delete(hub, ctx, source_arn: str, destination_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an association.

    Args:
        source_arn(str): The ARN of the source.
        destination_arn(str): The Amazon Resource Name (ARN) of the destination.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.association.delete(
                ctx, source_arn=value, destination_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.association.delete source_arn=value, destination_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_association",
        op_kwargs={"SourceArn": source_arn, "DestinationArn": destination_arn},
    )


async def list_all(
    hub,
    ctx,
    source_arn: str = None,
    destination_arn: str = None,
    source_type: str = None,
    destination_type: str = None,
    association_type: str = None,
    created_after: str = None,
    created_before: str = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the associations in your account and their properties.

    Args:
        source_arn(str, optional): A filter that returns only associations with the specified source ARN. Defaults to None.
        destination_arn(str, optional): A filter that returns only associations with the specified destination Amazon Resource Name (ARN). Defaults to None.
        source_type(str, optional): A filter that returns only associations with the specified source type. Defaults to None.
        destination_type(str, optional): A filter that returns only associations with the specified destination type. Defaults to None.
        association_type(str, optional): A filter that returns only associations of the specified type. Defaults to None.
        created_after(str, optional): A filter that returns only associations created on or after the specified time. Defaults to None.
        created_before(str, optional): A filter that returns only associations created on or before the specified time. Defaults to None.
        sort_by(str, optional): The property used to sort results. The default value is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order. The default value is Descending. Defaults to None.
        next_token(str, optional): If the previous call to ListAssociations didn't return the full set of associations, the call returns a token for getting the next set of associations. Defaults to None.
        max_results(int, optional): The maximum number of associations to return in the response. The default value is 10. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.association.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.association.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_associations",
        op_kwargs={
            "SourceArn": source_arn,
            "DestinationArn": destination_arn,
            "SourceType": source_type,
            "DestinationType": destination_type,
            "AssociationType": association_type,
            "CreatedAfter": created_after,
            "CreatedBefore": created_before,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
