"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    sort_order: str = None,
    sort_by: str = None,
    domain_id_equals: str = None,
    user_profile_name_equals: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists apps.

    Args:
        next_token(str, optional): If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results. Defaults to None.
        max_results(int, optional): Returns a list up to a specified limit. Defaults to None.
        sort_order(str, optional): The sort order for the results. The default is Ascending. Defaults to None.
        sort_by(str, optional): The parameter by which to sort the results. The default is CreationTime. Defaults to None.
        domain_id_equals(str, optional): A parameter to search for the domain ID. Defaults to None.
        user_profile_name_equals(str, optional): A parameter to search by user profile name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.apps.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.apps.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_apps",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "SortOrder": sort_order,
            "SortBy": sort_by,
            "DomainIdEquals": domain_id_equals,
            "UserProfileNameEquals": user_profile_name_equals,
        },
    )
