"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    domain_id: str,
    user_profile_name: str,
    app_type: str,
    app_name: str,
    tags: List = None,
    resource_spec: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a running app for the specified UserProfile. Supported apps are JupyterServer and KernelGateway. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.

    Args:
        domain_id(str): The domain ID.
        user_profile_name(str): The user profile name.
        app_type(str): The type of app. Supported apps are JupyterServer and KernelGateway. TensorBoard is not supported.
        app_name(str): The name of the app.
        tags(List, optional): Each tag consists of a key and an optional value. Tag keys must be unique per resource. Defaults to None.
        resource_spec(Dict, optional): The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.app.init.create(
                ctx, domain_id=value, user_profile_name=value, app_type=value, app_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.app.init.create domain_id=value, user_profile_name=value, app_type=value, app_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_app",
        op_kwargs={
            "DomainId": domain_id,
            "UserProfileName": user_profile_name,
            "AppType": app_type,
            "AppName": app_name,
            "Tags": tags,
            "ResourceSpec": resource_spec,
        },
    )


async def delete(
    hub, ctx, domain_id: str, user_profile_name: str, app_type: str, app_name: str
) -> None:
    r"""
    **Autogenerated function**

    Used to stop and delete an app.

    Args:
        domain_id(str): The domain ID.
        user_profile_name(str): The user profile name.
        app_type(str): The type of app.
        app_name(str): The name of the app.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.app.init.delete(
                ctx, domain_id=value, user_profile_name=value, app_type=value, app_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.app.init.delete domain_id=value, user_profile_name=value, app_type=value, app_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_app",
        op_kwargs={
            "DomainId": domain_id,
            "UserProfileName": user_profile_name,
            "AppType": app_type,
            "AppName": app_name,
        },
    )


async def describe(
    hub, ctx, domain_id: str, user_profile_name: str, app_type: str, app_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the app.

    Args:
        domain_id(str): The domain ID.
        user_profile_name(str): The user profile name.
        app_type(str): The type of app.
        app_name(str): The name of the app.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.app.init.describe(
                ctx, domain_id=value, user_profile_name=value, app_type=value, app_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.app.init.describe domain_id=value, user_profile_name=value, app_type=value, app_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_app",
        op_kwargs={
            "DomainId": domain_id,
            "UserProfileName": user_profile_name,
            "AppType": app_type,
            "AppName": app_name,
        },
    )
