"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    app_image_config_name: str,
    tags: List = None,
    kernel_gateway_image_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.

    Args:
        app_image_config_name(str): The name of the AppImageConfig. Must be unique to your account.
        tags(List, optional): A list of tags to apply to the AppImageConfig. Defaults to None.
        kernel_gateway_image_config(Dict, optional): The KernelGatewayImageConfig. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.app.image_config.create(
                ctx, app_image_config_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.app.image_config.create app_image_config_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_app_image_config",
        op_kwargs={
            "AppImageConfigName": app_image_config_name,
            "Tags": tags,
            "KernelGatewayImageConfig": kernel_gateway_image_config,
        },
    )


async def delete(hub, ctx, app_image_config_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an AppImageConfig.

    Args:
        app_image_config_name(str): The name of the AppImageConfig to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.app.image_config.delete(
                ctx, app_image_config_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.app.image_config.delete app_image_config_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_app_image_config",
        op_kwargs={"AppImageConfigName": app_image_config_name},
    )


async def describe(hub, ctx, app_image_config_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an AppImageConfig.

    Args:
        app_image_config_name(str): The name of the AppImageConfig to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.app.image_config.describe(
                ctx, app_image_config_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.app.image_config.describe app_image_config_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_app_image_config",
        op_kwargs={"AppImageConfigName": app_image_config_name},
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    name_contains: str = None,
    creation_time_before: str = None,
    creation_time_after: str = None,
    modified_time_before: str = None,
    modified_time_after: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or modified time, and whether the AppImageConfig name contains a specified string.

    Args:
        max_results(int, optional): The maximum number of AppImageConfigs to return in the response. The default value is 10. . Defaults to None.
        next_token(str, optional): If the previous call to ListImages didn't return the full set of AppImageConfigs, the call returns a token for getting the next set of AppImageConfigs. Defaults to None.
        name_contains(str, optional): A filter that returns only AppImageConfigs whose name contains the specified string. Defaults to None.
        creation_time_before(str, optional): A filter that returns only AppImageConfigs created on or before the specified time. Defaults to None.
        creation_time_after(str, optional): A filter that returns only AppImageConfigs created on or after the specified time. Defaults to None.
        modified_time_before(str, optional): A filter that returns only AppImageConfigs modified on or before the specified time. Defaults to None.
        modified_time_after(str, optional): A filter that returns only AppImageConfigs modified on or after the specified time. Defaults to None.
        sort_by(str, optional): The property used to sort results. The default value is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order. The default value is Descending. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.app.image_config.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.app.image_config.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_app_image_configs",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "NameContains": name_contains,
            "CreationTimeBefore": creation_time_before,
            "CreationTimeAfter": creation_time_after,
            "ModifiedTimeBefore": modified_time_before,
            "ModifiedTimeAfter": modified_time_after,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )


async def update(
    hub, ctx, app_image_config_name: str, kernel_gateway_image_config: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the properties of an AppImageConfig.

    Args:
        app_image_config_name(str): The name of the AppImageConfig to update.
        kernel_gateway_image_config(Dict, optional): The new KernelGateway app to run on the image. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.app.image_config.update(
                ctx, app_image_config_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.app.image_config.update app_image_config_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_app_image_config",
        op_kwargs={
            "AppImageConfigName": app_image_config_name,
            "KernelGatewayImageConfig": kernel_gateway_image_config,
        },
    )
