"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    algorithm_name: str,
    training_specification: Dict,
    algorithm_description: str = None,
    inference_specification: Dict = None,
    validation_specification: Dict = None,
    certify_for_marketplace: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a machine learning algorithm that you can use in Amazon SageMaker and list in the Amazon Web Services Marketplace.

    Args:
        algorithm_name(str): The name of the algorithm.
        algorithm_description(str, optional): A description of the algorithm. Defaults to None.
        training_specification(Dict): Specifies details about training jobs run by this algorithm, including the following:   The Amazon ECR path of the container and the version digest of the algorithm.   The hyperparameters that the algorithm supports.   The instance types that the algorithm supports for training.   Whether the algorithm supports distributed training.   The metrics that the algorithm emits to Amazon CloudWatch.   Which metrics that the algorithm emits can be used as the objective metric for hyperparameter tuning jobs.   The input channels that the algorithm supports for training data. For example, an algorithm might support train, validation, and test channels.  .
        inference_specification(Dict, optional): Specifies details about inference jobs that the algorithm runs, including the following:   The Amazon ECR paths of containers that contain the inference code and model artifacts.   The instance types that the algorithm supports for transform jobs and real-time endpoints used for inference.   The input and output content formats that the algorithm supports for inference.  . Defaults to None.
        validation_specification(Dict, optional): Specifies configurations for one or more training jobs and that Amazon SageMaker runs to test the algorithm's training code and, optionally, one or more batch transform jobs that Amazon SageMaker runs to test the algorithm's inference code. Defaults to None.
        certify_for_marketplace(bool, optional): Whether to certify the algorithm so that it can be listed in Amazon Web Services Marketplace. Defaults to None.
        tags(List, optional): An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see Tagging Amazon Web Services Resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.algorithm.create(
                ctx, algorithm_name=value, training_specification=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.algorithm.create algorithm_name=value, training_specification=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_algorithm",
        op_kwargs={
            "AlgorithmName": algorithm_name,
            "AlgorithmDescription": algorithm_description,
            "TrainingSpecification": training_specification,
            "InferenceSpecification": inference_specification,
            "ValidationSpecification": validation_specification,
            "CertifyForMarketplace": certify_for_marketplace,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, algorithm_name: str) -> None:
    r"""
    **Autogenerated function**

    Removes the specified algorithm from your account.

    Args:
        algorithm_name(str): The name of the algorithm to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.algorithm.delete(ctx, algorithm_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.algorithm.delete algorithm_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_algorithm",
        op_kwargs={"AlgorithmName": algorithm_name},
    )


async def describe(hub, ctx, algorithm_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of the specified algorithm that is in your account.

    Args:
        algorithm_name(str): The name of the algorithm to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.algorithm.describe(ctx, algorithm_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.algorithm.describe algorithm_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_algorithm",
        op_kwargs={"AlgorithmName": algorithm_name},
    )


async def list_all(
    hub,
    ctx,
    creation_time_after: str = None,
    creation_time_before: str = None,
    max_results: int = None,
    name_contains: str = None,
    next_token: str = None,
    sort_by: str = None,
    sort_order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the machine learning algorithms that have been created.

    Args:
        creation_time_after(str, optional): A filter that returns only algorithms created after the specified time (timestamp). Defaults to None.
        creation_time_before(str, optional): A filter that returns only algorithms created before the specified time (timestamp). Defaults to None.
        max_results(int, optional): The maximum number of algorithms to return in the response. Defaults to None.
        name_contains(str, optional): A string in the algorithm name. This filter returns only algorithms whose name contains the specified string. Defaults to None.
        next_token(str, optional): If the response to a previous ListAlgorithms request was truncated, the response includes a NextToken. To retrieve the next set of algorithms, use the token in the next request. Defaults to None.
        sort_by(str, optional): The parameter by which to sort the results. The default is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order for the results. The default is Ascending. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.algorithm.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.algorithm.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_algorithms",
        op_kwargs={
            "CreationTimeAfter": creation_time_after,
            "CreationTimeBefore": creation_time_before,
            "MaxResults": max_results,
            "NameContains": name_contains,
            "NextToken": next_token,
            "SortBy": sort_by,
            "SortOrder": sort_order,
        },
    )
