"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    action_name: str,
    source: Dict,
    action_type: str,
    description: str = None,
    status: str = None,
    properties: Dict = None,
    metadata_properties: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an action. An action is a lineage tracking entity that represents an action or activity. For example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact. For more information, see Amazon SageMaker ML Lineage Tracking.   CreateAction can only be invoked from within an SageMaker managed environment. This includes SageMaker training jobs, processing jobs, transform jobs, and SageMaker notebooks. A call to CreateAction from outside one of these environments results in an error.

    Args:
        action_name(str): The name of the action. Must be unique to your account in an Amazon Web Services Region.
        source(Dict): The source type, ID, and URI.
        action_type(str): The action type.
        description(str, optional): The description of the action. Defaults to None.
        status(str, optional): The status of the action. Defaults to None.
        properties(Dict, optional): A list of properties to add to the action. Defaults to None.
        metadata_properties(Dict, optional): Metadata properties of the tracking entity, trial, or trial component. Defaults to None.
        tags(List, optional): A list of tags to apply to the action. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.action.create(
                ctx, action_name=value, source=value, action_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.action.create action_name=value, source=value, action_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="create_action",
        op_kwargs={
            "ActionName": action_name,
            "Source": source,
            "ActionType": action_type,
            "Description": description,
            "Status": status,
            "Properties": properties,
            "MetadataProperties": metadata_properties,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, action_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an action.

    Args:
        action_name(str): The name of the action to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.action.delete(ctx, action_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.action.delete action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="delete_action",
        op_kwargs={"ActionName": action_name},
    )


async def describe(hub, ctx, action_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an action.

    Args:
        action_name(str): The name of the action to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.action.describe(ctx, action_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.action.describe action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="describe_action",
        op_kwargs={"ActionName": action_name},
    )


async def list_all(
    hub,
    ctx,
    source_uri: str = None,
    action_type: str = None,
    created_after: str = None,
    created_before: str = None,
    sort_by: str = None,
    sort_order: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the actions in your account and their properties.

    Args:
        source_uri(str, optional): A filter that returns only actions with the specified source URI. Defaults to None.
        action_type(str, optional): A filter that returns only actions of the specified type. Defaults to None.
        created_after(str, optional): A filter that returns only actions created on or after the specified time. Defaults to None.
        created_before(str, optional): A filter that returns only actions created on or before the specified time. Defaults to None.
        sort_by(str, optional): The property used to sort results. The default value is CreationTime. Defaults to None.
        sort_order(str, optional): The sort order. The default value is Descending. Defaults to None.
        next_token(str, optional): If the previous call to ListActions didn't return the full set of actions, the call returns a token for getting the next set of actions. Defaults to None.
        max_results(int, optional): The maximum number of actions to return in the response. The default value is 10. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.action.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.action.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="list_actions",
        op_kwargs={
            "SourceUri": source_uri,
            "ActionType": action_type,
            "CreatedAfter": created_after,
            "CreatedBefore": created_before,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    action_name: str,
    description: str = None,
    status: str = None,
    properties: Dict = None,
    properties_to_remove: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an action.

    Args:
        action_name(str): The name of the action to update.
        description(str, optional): The new description for the action. Defaults to None.
        status(str, optional): The new status for the action. Defaults to None.
        properties(Dict, optional): The new list of properties. Overwrites the current property list. Defaults to None.
        properties_to_remove(List, optional): A list of properties to remove. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sagemaker.action.update(ctx, action_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sagemaker.action.update action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sagemaker",
        operation="update_action",
        op_kwargs={
            "ActionName": action_name,
            "Description": description,
            "Status": status,
            "Properties": properties,
            "PropertiesToRemove": properties_to_remove,
        },
    )
