"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, config_id: str, account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the Amazon S3 Storage Lens configuration tags. For more information about S3 Storage Lens, see Assessing your storage activity and usage with Amazon S3 Storage Lens  in the Amazon S3 User Guide.  To use this action, you must have permission to perform the s3:DeleteStorageLensConfigurationTagging action. For more information, see Setting permissions to use Amazon S3 Storage Lens in the Amazon S3 User Guide.

    Args:
        config_id(str): The ID of the S3 Storage Lens configuration.
        account_id(str): The account ID of the requester.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.storage_lens_configuration.tagging.delete(
                ctx, config_id=value, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.storage_lens_configuration.tagging.delete config_id=value, account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="delete_storage_lens_configuration_tagging",
        op_kwargs={"ConfigId": config_id, "AccountId": account_id},
    )


async def get(hub, ctx, config_id: str, account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the tags of Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see Assessing your storage activity and usage with Amazon S3 Storage Lens  in the Amazon S3 User Guide.  To use this action, you must have permission to perform the s3:GetStorageLensConfigurationTagging action. For more information, see Setting permissions to use Amazon S3 Storage Lens in the Amazon S3 User Guide.

    Args:
        config_id(str): The ID of the Amazon S3 Storage Lens configuration.
        account_id(str): The account ID of the requester.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.storage_lens_configuration.tagging.get(
                ctx, config_id=value, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.storage_lens_configuration.tagging.get config_id=value, account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_storage_lens_configuration_tagging",
        op_kwargs={"ConfigId": config_id, "AccountId": account_id},
    )


async def put(hub, ctx, config_id: str, account_id: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Put or replace tags on an existing Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see Assessing your storage activity and usage with Amazon S3 Storage Lens  in the Amazon S3 User Guide.  To use this action, you must have permission to perform the s3:PutStorageLensConfigurationTagging action. For more information, see Setting permissions to use Amazon S3 Storage Lens in the Amazon S3 User Guide.

    Args:
        config_id(str): The ID of the S3 Storage Lens configuration.
        account_id(str): The account ID of the requester.
        tags(List): The tag set of the S3 Storage Lens configuration.  You can set up to a maximum of 50 tags. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.storage_lens_configuration.tagging.put(
                ctx, config_id=value, account_id=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.storage_lens_configuration.tagging.put config_id=value, account_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="put_storage_lens_configuration_tagging",
        op_kwargs={"ConfigId": config_id, "AccountId": account_id, "Tags": tags},
    )
