"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, config_id: str, account_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see Assessing your storage activity and usage with Amazon S3 Storage Lens  in the Amazon S3 User Guide.  To use this action, you must have permission to perform the s3:DeleteStorageLensConfiguration action. For more information, see Setting permissions to use Amazon S3 Storage Lens in the Amazon S3 User Guide.

    Args:
        config_id(str): The ID of the S3 Storage Lens configuration.
        account_id(str): The account ID of the requester.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.storage_lens_configuration.init.delete(
                ctx, config_id=value, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.storage_lens_configuration.init.delete config_id=value, account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="delete_storage_lens_configuration",
        op_kwargs={"ConfigId": config_id, "AccountId": account_id},
    )


async def get(hub, ctx, config_id: str, account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the Amazon S3 Storage Lens configuration. For more information, see Assessing your storage activity and usage with Amazon S3 Storage Lens  in the Amazon S3 User Guide.  To use this action, you must have permission to perform the s3:GetStorageLensConfiguration action. For more information, see Setting permissions to use Amazon S3 Storage Lens in the Amazon S3 User Guide.

    Args:
        config_id(str): The ID of the Amazon S3 Storage Lens configuration.
        account_id(str): The account ID of the requester.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.storage_lens_configuration.init.get(
                ctx, config_id=value, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.storage_lens_configuration.init.get config_id=value, account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_storage_lens_configuration",
        op_kwargs={"ConfigId": config_id, "AccountId": account_id},
    )


async def list_all(hub, ctx, account_id: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of Amazon S3 Storage Lens configurations. For more information about S3 Storage Lens, see Assessing your storage activity and usage with Amazon S3 Storage Lens  in the Amazon S3 User Guide.  To use this action, you must have permission to perform the s3:ListStorageLensConfigurations action. For more information, see Setting permissions to use Amazon S3 Storage Lens in the Amazon S3 User Guide.

    Args:
        account_id(str): The account ID of the requester.
        next_token(str, optional): A pagination token to request the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.storage_lens_configuration.init.list_all(
                ctx, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.storage_lens_configuration.init.list_all account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="list_storage_lens_configurations",
        op_kwargs={"AccountId": account_id, "NextToken": next_token},
    )


async def put(
    hub,
    ctx,
    config_id: str,
    account_id: str,
    storage_lens_configuration: Dict,
    tags: List = None,
) -> None:
    r"""
    **Autogenerated function**

    Puts an Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see Working with Amazon S3 Storage Lens in the Amazon S3 User Guide.  To use this action, you must have permission to perform the s3:PutStorageLensConfiguration action. For more information, see Setting permissions to use Amazon S3 Storage Lens in the Amazon S3 User Guide.

    Args:
        config_id(str): The ID of the S3 Storage Lens configuration.
        account_id(str): The account ID of the requester.
        storage_lens_configuration(Dict): The S3 Storage Lens configuration.
        tags(List, optional): The tag set of the S3 Storage Lens configuration.  You can set up to a maximum of 50 tags. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.storage_lens_configuration.init.put(
                ctx, config_id=value, account_id=value, storage_lens_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.storage_lens_configuration.init.put config_id=value, account_id=value, storage_lens_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="put_storage_lens_configuration",
        op_kwargs={
            "ConfigId": config_id,
            "AccountId": account_id,
            "StorageLensConfiguration": storage_lens_configuration,
            "Tags": tags,
        },
    )
