"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    account_id: str,
    next_token: str = None,
    max_results: int = None,
    outpost_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all Outposts buckets in an Outpost that are owned by the authenticated sender of the request. For more information, see Using Amazon S3 on Outposts in the Amazon S3 User Guide. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and x-amz-outpost-id in your request, see the Examples section.

    Args:
        account_id(str): The account ID of the Outposts bucket.
        next_token(str, optional): . Defaults to None.
        max_results(int, optional): . Defaults to None.
        outpost_id(str, optional): The ID of the Outposts.  This is required by Amazon S3 on Outposts buckets. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.regional_bucket.list_all(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.regional_bucket.list_all account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="list_regional_buckets",
        op_kwargs={
            "AccountId": account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "OutpostId": outpost_id,
        },
    )
