"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, account_id: str) -> None:
    r"""
    **Autogenerated function**

    Removes the PublicAccessBlock configuration for an account. For more information, see  Using Amazon S3 block public access. Related actions include:    GetPublicAccessBlock     PutPublicAccessBlock

    Args:
        account_id(str): The account ID for the account whose PublicAccessBlock configuration you want to remove.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.public_access_block.delete(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.public_access_block.delete account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="delete_public_access_block",
        op_kwargs={"AccountId": account_id},
    )


async def get(hub, ctx, account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the PublicAccessBlock configuration for an account. For more information, see  Using Amazon S3 block public access. Related actions include:    DeletePublicAccessBlock     PutPublicAccessBlock

    Args:
        account_id(str): The account ID for the account whose PublicAccessBlock configuration you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.public_access_block.get(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.public_access_block.get account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_public_access_block",
        op_kwargs={"AccountId": account_id},
    )


async def put(
    hub, ctx, public_access_block_configuration: Dict, account_id: str
) -> None:
    r"""
    **Autogenerated function**

    Creates or modifies the PublicAccessBlock configuration for an account. For more information, see  Using Amazon S3 block public access. Related actions include:    GetPublicAccessBlock     DeletePublicAccessBlock

    Args:
        public_access_block_configuration(Dict): The PublicAccessBlock configuration that you want to apply to the specified account.
        account_id(str): The account ID for the account whose PublicAccessBlock configuration you want to set.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.public_access_block.put(
                ctx, public_access_block_configuration=value, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.public_access_block.put public_access_block_configuration=value, account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="put_public_access_block",
        op_kwargs={
            "PublicAccessBlockConfiguration": public_access_block_configuration,
            "AccountId": account_id,
        },
    )
