"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, account_id: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the entire tag set from the specified S3 Batch Operations job. To use this operation, you must have permission to perform the s3:DeleteJobTagging action. For more information, see Controlling access and labeling jobs using tags in the Amazon S3 User Guide.  Related actions include:    CreateJob     GetJobTagging     PutJobTagging

    Args:
        account_id(str): The account ID associated with the S3 Batch Operations job.
        job_id(str): The ID for the S3 Batch Operations job whose tags you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.job.tagging.delete(
                ctx, account_id=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.job.tagging.delete account_id=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="delete_job_tagging",
        op_kwargs={"AccountId": account_id, "JobId": job_id},
    )


async def get(hub, ctx, account_id: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the tags on an S3 Batch Operations job. To use this operation, you must have permission to perform the s3:GetJobTagging action. For more information, see Controlling access and labeling jobs using tags in the Amazon S3 User Guide.  Related actions include:    CreateJob     PutJobTagging     DeleteJobTagging

    Args:
        account_id(str): The account ID associated with the S3 Batch Operations job.
        job_id(str): The ID for the S3 Batch Operations job whose tags you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.job.tagging.get(ctx, account_id=value, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.job.tagging.get account_id=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_job_tagging",
        op_kwargs={"AccountId": account_id, "JobId": job_id},
    )


async def put(hub, ctx, account_id: str, job_id: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Sets the supplied tag-set on an S3 Batch Operations job. A tag is a key-value pair. You can associate S3 Batch Operations tags with any job by sending a PUT request against the tagging subresource that is associated with the job. To modify the existing tag set, you can either replace the existing tag set entirely, or make changes within the existing tag set by retrieving the existing tag set using GetJobTagging, modify that tag set, and use this action to replace the tag set with the one you modified. For more information, see Controlling access and labeling jobs using tags in the Amazon S3 User Guide.      If you send this request with an empty tag set, Amazon S3 deletes the existing tag set on the Batch Operations job. If you use this method, you are charged for a Tier 1 Request (PUT). For more information, see Amazon S3 pricing.   For deleting existing tags for your Batch Operations job, a DeleteJobTagging request is preferred because it achieves the same result without incurring charges.   A few things to consider about using tags:   Amazon S3 limits the maximum number of tags to 50 tags per job.   You can associate up to 50 tags with a job as long as they have unique tag keys.   A tag key can be up to 128 Unicode characters in length, and tag values can be up to 256 Unicode characters in length.   The key and values are case sensitive.   For tagging-related restrictions related to characters and encodings, see User-Defined Tag Restrictions in the Billing and Cost Management User Guide.       To use this action, you must have permission to perform the s3:PutJobTagging action. Related actions include:    CreatJob     GetJobTagging     DeleteJobTagging

    Args:
        account_id(str): The account ID associated with the S3 Batch Operations job.
        job_id(str): The ID for the S3 Batch Operations job whose tags you want to replace.
        tags(List): The set of tags to associate with the S3 Batch Operations job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.job.tagging.put(
                ctx, account_id=value, job_id=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.job.tagging.put account_id=value, job_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="put_job_tagging",
        op_kwargs={"AccountId": account_id, "JobId": job_id, "Tags": tags},
    )
