"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    account_id: str,
    job_id: str,
    requested_job_status: str,
    status_update_reason: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the status for the specified job. Use this action to confirm that you want to run a job or to cancel an existing job. For more information, see S3 Batch Operations in the Amazon S3 User Guide.  Related actions include:    CreateJob     ListJobs     DescribeJob     UpdateJobStatus

    Args:
        account_id(str): The account ID associated with the S3 Batch Operations job.
        job_id(str): The ID of the job whose status you want to update.
        requested_job_status(str): The status that you want to move the specified job to.
        status_update_reason(str, optional): A description of the reason why you want to change the specified job's status. This field can be any string up to the maximum length. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.job.status.update(
                ctx, account_id=value, job_id=value, requested_job_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.job.status.update account_id=value, job_id=value, requested_job_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="update_job_status",
        op_kwargs={
            "AccountId": account_id,
            "JobId": job_id,
            "RequestedJobStatus": requested_job_status,
            "StatusUpdateReason": status_update_reason,
        },
    )
