"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, account_id: str, job_id: str, priority: int) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing S3 Batch Operations job's priority. For more information, see S3 Batch Operations in the Amazon S3 User Guide.  Related actions include:    CreateJob     ListJobs     DescribeJob     UpdateJobStatus

    Args:
        account_id(str): The account ID associated with the S3 Batch Operations job.
        job_id(str): The ID for the job whose priority you want to update.
        priority(int): The priority you want to assign to this job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.job.priority.update(
                ctx, account_id=value, job_id=value, priority=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.job.priority.update account_id=value, job_id=value, priority=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="update_job_priority",
        op_kwargs={"AccountId": account_id, "JobId": job_id, "Priority": priority},
    )
