"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    account_id: str,
    operation: Dict,
    report: Dict,
    client_request_token: str,
    manifest: Dict,
    priority: int,
    role_arn: str,
    confirmation_required: bool = None,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    You can use S3 Batch Operations to perform large-scale batch actions on Amazon S3 objects. Batch Operations can run a single action on lists of Amazon S3 objects that you specify. For more information, see S3 Batch Operations in the Amazon S3 User Guide. This action creates a S3 Batch Operations job.  Related actions include:    DescribeJob     ListJobs     UpdateJobPriority     UpdateJobStatus     JobOperation

    Args:
        account_id(str): The account ID that creates the job.
        confirmation_required(bool, optional): Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console. Defaults to None.
        operation(Dict): The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see Operations in the Amazon S3 User Guide.
        report(Dict): Configuration parameters for the optional job-completion report.
        client_request_token(str): An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.
        manifest(Dict): Configuration parameters for the manifest.
        description(str, optional): A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs. Defaults to None.
        priority(int): The numerical priority for this job. Higher numbers indicate higher priority.
        role_arn(str): The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job's action on every object in the manifest.
        tags(List, optional): A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.job.init.create(
                ctx,
                account_id=value,
                operation=value,
                report=value,
                client_request_token=value,
                manifest=value,
                priority=value,
                role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.job.init.create account_id=value, operation=value, report=value, client_request_token=value, manifest=value, priority=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="create_job",
        op_kwargs={
            "AccountId": account_id,
            "ConfirmationRequired": confirmation_required,
            "Operation": operation,
            "Report": report,
            "ClientRequestToken": client_request_token,
            "Manifest": manifest,
            "Description": description,
            "Priority": priority,
            "RoleArn": role_arn,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, account_id: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the configuration parameters and status for a Batch Operations job. For more information, see S3 Batch Operations in the Amazon S3 User Guide.  Related actions include:    CreateJob     ListJobs     UpdateJobPriority     UpdateJobStatus

    Args:
        account_id(str): The account ID associated with the S3 Batch Operations job.
        job_id(str): The ID for the job whose information you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.job.init.describe(ctx, account_id=value, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.job.init.describe account_id=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="describe_job",
        op_kwargs={"AccountId": account_id, "JobId": job_id},
    )
