"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    bucket: str,
    acl: str = None,
    create_bucket_configuration: Dict = None,
    grant_full_control: str = None,
    grant_read: str = None,
    grant_read_acp: str = None,
    grant_write: str = None,
    grant_write_acp: str = None,
    object_lock_enabled_for_bucket: bool = None,
    outpost_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see Create Bucket in the Amazon S3 API Reference.   Creates a new Outposts bucket. By creating the bucket, you become the bucket owner. To create an Outposts bucket, you must have S3 on Outposts. For more information, see Using Amazon S3 on Outposts in Amazon S3 User Guide. Not every string is an acceptable bucket name. For information on bucket naming restrictions, see Working with Amazon S3 Buckets. S3 on Outposts buckets support:   Tags   LifecycleConfigurations for deleting expired objects   For a complete list of restrictions and Amazon S3 feature limitations on S3 on Outposts, see  Amazon S3 on Outposts Restrictions and Limitations. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and x-amz-outpost-id in your API request, see the Examples section. The following actions are related to CreateBucket for Amazon S3 on Outposts:    PutObject     GetBucket     DeleteBucket     CreateAccessPoint     PutAccessPointPolicy

    Args:
        acl(str, optional): The canned ACL to apply to the bucket.  This is not supported by Amazon S3 on Outposts buckets. . Defaults to None.
        bucket(str): The name of the bucket.
        create_bucket_configuration(Dict, optional): The configuration information for the bucket.  This is not supported by Amazon S3 on Outposts buckets. . Defaults to None.
        grant_full_control(str, optional): Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.  This is not supported by Amazon S3 on Outposts buckets. . Defaults to None.
        grant_read(str, optional): Allows grantee to list the objects in the bucket.  This is not supported by Amazon S3 on Outposts buckets. . Defaults to None.
        grant_read_acp(str, optional): Allows grantee to read the bucket ACL.  This is not supported by Amazon S3 on Outposts buckets. . Defaults to None.
        grant_write(str, optional): Allows grantee to create, overwrite, and delete any object in the bucket.  This is not supported by Amazon S3 on Outposts buckets. . Defaults to None.
        grant_write_acp(str, optional): Allows grantee to write the ACL for the applicable bucket.  This is not supported by Amazon S3 on Outposts buckets. . Defaults to None.
        object_lock_enabled_for_bucket(bool, optional): Specifies whether you want S3 Object Lock to be enabled for the new bucket.  This is not supported by Amazon S3 on Outposts buckets. . Defaults to None.
        outpost_id(str, optional): The ID of the Outposts where the bucket is being created.  This is required by Amazon S3 on Outposts buckets. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.bucket.init.create(ctx, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.bucket.init.create bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="create_bucket",
        op_kwargs={
            "ACL": acl,
            "Bucket": bucket,
            "CreateBucketConfiguration": create_bucket_configuration,
            "GrantFullControl": grant_full_control,
            "GrantRead": grant_read,
            "GrantReadACP": grant_read_acp,
            "GrantWrite": grant_write,
            "GrantWriteACP": grant_write_acp,
            "ObjectLockEnabledForBucket": object_lock_enabled_for_bucket,
            "OutpostId": outpost_id,
        },
    )


async def delete(hub, ctx, account_id: str, bucket: str) -> None:
    r"""
    **Autogenerated function**

     This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket, see DeleteBucket in the Amazon S3 API Reference.   Deletes the Amazon S3 on Outposts bucket. All objects (including all object versions and delete markers) in the bucket must be deleted before the bucket itself can be deleted. For more information, see Using Amazon S3 on Outposts in Amazon S3 User Guide. All Amazon S3 on Outposts REST API requests for this action require an additional parameter of x-amz-outpost-id to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of s3-control. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived using the access point ARN, see the Examples section.  Related Resources     CreateBucket     GetBucket     DeleteObject

    Args:
        account_id(str): The account ID that owns the Outposts bucket.
        bucket(str): Specifies the bucket being deleted. For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well. For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>. For example, to access the bucket reports through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports. The value must be URL encoded. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.bucket.init.delete(
                ctx, account_id=value, bucket=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.bucket.init.delete account_id=value, bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="delete_bucket",
        op_kwargs={"AccountId": account_id, "Bucket": bucket},
    )


async def get(hub, ctx, account_id: str, bucket: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets an Amazon S3 on Outposts bucket. For more information, see  Using Amazon S3 on Outposts in the Amazon S3 User Guide. If you are using an identity other than the root user of the account that owns the Outposts bucket, the calling identity must have the s3-outposts:GetBucket permissions on the specified Outposts bucket and belong to the Outposts bucket owner's account in order to use this action. Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket.   If you don't have s3-outposts:GetBucket permissions or you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a 403 Access Denied error. The following actions are related to GetBucket for Amazon S3 on Outposts: All Amazon S3 on Outposts REST API requests for this action require an additional parameter of x-amz-outpost-id to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of s3-control. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived using the access point ARN, see the Examples section.    PutObject     CreateBucket     DeleteBucket

    Args:
        account_id(str): The account ID of the Outposts bucket.
        bucket(str): Specifies the bucket. For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well. For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>. For example, to access the bucket reports through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports. The value must be URL encoded. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.bucket.init.get(ctx, account_id=value, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.bucket.init.get account_id=value, bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_bucket",
        op_kwargs={"AccountId": account_id, "Bucket": bucket},
    )
