"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, account_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Indicates whether the specified access point currently has a policy that allows public access. For more information about public access through access points, see Managing Data Access with Amazon S3 access points in the Amazon S3 User Guide.

    Args:
        account_id(str): The account ID for the account that owns the specified access point.
        name(str): The name of the access point whose policy status you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.policy.status.init.get(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.policy.status.init.get account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_access_point_policy_status",
        op_kwargs={"AccountId": account_id, "Name": name},
    )
