"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "for_object_lambda"


async def get(hub, ctx, account_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the status of the resource policy associated with an Object Lambda Access Point.

    Args:
        account_id(str): The account ID for the account that owns the specified Object Lambda Access Point.
        name(str): The name of the Object Lambda Access Point.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.policy.status.for_object_lambda_.get(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.policy.status.for_object_lambda.get account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_access_point_policy_status_for_object_lambda",
        op_kwargs={"AccountId": account_id, "Name": name},
    )
